/*
 * Decompiled with CFR 0.152.
 */
package com.borland.primetime.insight.template;

import com.borland.primetime.editor.EditorManager;
import com.borland.primetime.editor.EditorPane;
import com.borland.primetime.editor.TextUtilities;
import com.borland.primetime.ide.Browser;
import com.borland.primetime.insight.template.CodeTemplate;
import com.borland.primetime.insight.template.TemplateManager;
import com.borland.primetime.insight.template.TemplatePopup;
import com.borland.primetime.insight.template.TemplateSet;
import com.borland.primetime.insight.template.s;
import com.borland.primetime.node.Project;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Arrays;
import java.util.EventListener;
import javax.swing.Action;
import javax.swing.DefaultListModel;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.plaf.TextUI;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.Segment;

public class PopupController
implements CaretListener,
MouseListener,
KeyListener,
FocusListener,
DocumentListener {
    static Class h;
    public static final String TEMPLATE_DELIMITERS;
    protected TemplateSet templateSet;
    protected CodeTemplate[] templateMap;
    private int f;
    private int e;
    private int c;
    private TemplatePopup d;
    private EditorPane g;

    static {
        TEMPLATE_DELIMITERS = TemplateManager.TEMPLATE_DELIMITERS;
    }

    static TemplatePopup a(PopupController popupController) {
        return popupController.d;
    }

    static Class a(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public void caretUpdate(CaretEvent caretEvent) {
        if (!this.isPopupVisible()) {
            return;
        }
        if (caretEvent.getDot() < this.f) {
            this.removePopup();
        } else {
            int n2;
            int n3 = this.g.getLineNumber(this.f);
            if (n3 != (n2 = this.g.getLineNumber(caretEvent.getDot()))) {
                this.removePopup();
                return;
            }
        }
    }

    public void changedUpdate(DocumentEvent documentEvent) {
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.d();
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.d();
    }

    public void focusLost(FocusEvent focusEvent) {
        if (!focusEvent.isTemporary()) {
            this.removePopup();
        }
    }

    public void focusGained(FocusEvent focusEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (!this.isPopupVisible()) {
            return;
        }
        if (mouseEvent.getClickCount() == 2) {
            this.a();
            mouseEvent.consume();
            this.removePopup();
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (!this.isPopupVisible()) {
            return;
        }
        int n2 = keyEvent.getKeyCode();
        switch (n2) {
            case 10: {
                this.a();
                this.removePopup();
                break;
            }
            case 27: {
                this.removePopup();
                break;
            }
            case 37: {
                KeyStroke keyStroke = KeyStroke.getKeyStroke(37, keyEvent.getModifiers());
                Action action = this.g.getKeymap().getAction(keyStroke);
                if (action == null) break;
                String string = null;
                string = String.valueOf(keyEvent.getKeyCode());
                ActionEvent actionEvent = new ActionEvent(this.g, 1001, string, keyEvent.getModifiers());
                action.actionPerformed(actionEvent);
                break;
            }
            case 8: {
                KeyStroke keyStroke = KeyStroke.getKeyStroke(8, keyEvent.getModifiers());
                Action action = this.g.getKeymap().getAction(keyStroke);
                if (action == null) break;
                String string = null;
                string = String.valueOf(keyEvent.getKeyCode());
                ActionEvent actionEvent = new ActionEvent(this.g, 1001, string, keyEvent.getModifiers());
                action.actionPerformed(actionEvent);
                break;
            }
            default: {
                this.d.captureKeyEvent(keyEvent);
                break;
            }
        }
        keyEvent.consume();
    }

    public void keyTyped(KeyEvent keyEvent) {
        if (!this.isPopupVisible()) {
            return;
        }
        char c2 = keyEvent.getKeyChar();
        if (TEMPLATE_DELIMITERS.indexOf(c2) != -1) {
            keyEvent.consume();
        } else if (!(keyEvent.getSource() instanceof EditorPane)) {
            String string = null;
            if (keyEvent.getKeyChar() != '\uffff') {
                string = String.valueOf(keyEvent.getKeyChar());
            }
            ActionEvent actionEvent = new ActionEvent(this.g, 1001, string, 0);
            this.g.getKeymap().getDefaultAction().actionPerformed(actionEvent);
            this.g.removeKeyListener(this);
            EventListener[] eventListenerArray = this.g.getListeners(h == null ? (h = PopupController.a("java.awt.event.KeyListener")) : h);
            keyEvent.setSource(this.g);
            for (int i2 = 0; i2 < eventListenerArray.length; ++i2) {
                ((KeyListener)eventListenerArray[i2]).keyTyped(keyEvent);
            }
            this.g.addKeyListener(this);
            keyEvent.consume();
        }
    }

    private void a() {
        CodeTemplate codeTemplate = this.d.getSelectedItem();
        if (codeTemplate != null) {
            String string = TextUtilities.ripTextAt(this.g, this.c, TEMPLATE_DELIMITERS);
            this.e = this.c + string.length();
            this.expandTemplate(this.g, codeTemplate, this.c, this.e);
        }
    }

    private void d() {
        if (!this.isPopupVisible()) {
            return;
        }
        String string = TextUtilities.ripTextAt(this.g, this.c, TEMPLATE_DELIMITERS);
        int n2 = Arrays.binarySearch(this.templateMap, string);
        if (n2 >= 0) {
            this.d.setSelectedIndex(n2);
        } else {
            int n3 = Math.min(-n2 - 1, this.templateMap.length - 1);
            CodeTemplate codeTemplate = this.templateMap[n3];
            if (string.length() > 0 && codeTemplate.getTemplateName().startsWith(string)) {
                this.d.setSelectedIndex(n3);
            } else {
                this.d.setSelectedIndex(n2);
            }
        }
    }

    protected boolean isPopupVisible() {
        return this.d != null && this.d.isVisible();
    }

    protected void removePopup() {
        this.g.getDocument().removeDocumentListener(this);
        this.g.removeKeyListener(this);
        this.g.removeCaretListener(this);
        this.g.removeFocusListener(this);
        this.g.setPopupEnabled(true);
        this.f = 0;
        ((Component)this.d).setVisible(false);
        this.d.dispose();
    }

    protected void doPopup(EditorPane editorPane, int n2, int n3, int n4) throws BadLocationException {
        this.d = new TemplatePopup(editorPane, this, this.templateSet);
        this.c = n2;
        this.e = n3;
        editorPane.setPopupEnabled(false);
        editorPane.addFocusListener(this);
        editorPane.addCaretListener(this);
        editorPane.addKeyListener(this);
        editorPane.getDocument().addDocumentListener(this);
        TextUI textUI = editorPane.getUI();
        Rectangle rectangle = textUI.modelToView(editorPane, n2);
        Rectangle rectangle2 = textUI.modelToView(editorPane, n3);
        Point point = new Point(rectangle.x, rectangle.y);
        SwingUtilities.convertPointToScreen(point, editorPane);
        Rectangle rectangle3 = new Rectangle(point.x, point.y, rectangle2.x - rectangle.x, editorPane.getFontHeight());
        DefaultListModel<CodeTemplate> defaultListModel = new DefaultListModel<CodeTemplate>();
        for (int i2 = 0; i2 < this.templateMap.length; ++i2) {
            defaultListModel.addElement(this.templateMap[i2]);
        }
        this.d.setHostFont(editorPane.getFont());
        this.d.setListModel(defaultListModel);
        SwingUtilities.invokeLater(new s(this, n4));
        this.d.show(rectangle3);
    }

    protected void expandTemplate(EditorPane editorPane, CodeTemplate codeTemplate, int n2, int n3) {
        try {
            String string;
            int n4;
            Document document = editorPane.getDocument();
            Element element = document.getDefaultRootElement();
            int n5 = element.getElementIndex(n2);
            Element element2 = element.getElement(n5);
            int n6 = element2.getStartOffset();
            int n7 = element2.getEndOffset();
            Segment segment = new Segment();
            document.getText(n6, n7 - n6, segment);
            int n8 = EditorManager.getTabSize();
            int n9 = -1;
            for (n4 = segment.offset; n4 < segment.offset + n7 - n6; ++n4) {
                char c2 = segment.array[n4];
                if (c2 == ' ' || c2 == '\t') continue;
                n9 = n4 - segment.offset + n6;
                break;
            }
            if (n9 == -1) {
                n9 = n2;
            }
            n4 = TextUtilities.getTabbedTextPosition(segment, n8, n9 - n6);
            char[] cArray = new char[n4];
            for (int i2 = 0; i2 < n4; ++i2) {
                cArray[i2] = 32;
            }
            String string2 = new String(cArray);
            Browser browser = Browser.getActiveBrowser();
            Project project = browser.getActiveProject();
            boolean bl = false;
            if (project != null && (string = project.getProperty("BraceStyle")) != null && string.equals("1")) {
                bl = true;
            }
            editorPane.startUndoGroup();
            int n10 = n3 - n2;
            if (n10 > 0) {
                document.remove(n2, n10);
            }
            String string3 = codeTemplate.getExpandedString();
            if (TemplateManager.isStockTemplate(codeTemplate.getTemplateName())) {
                string3 = TemplateManager.formatTemplateString(string3);
            }
            char[] cArray2 = string3.toCharArray();
            int n11 = 0;
            int n12 = -1;
            int n13 = n2;
            block9: for (int i3 = 0; i3 < cArray2.length; ++i3) {
                char c3 = cArray2[i3];
                switch (c3) {
                    case '\n': {
                        String string4 = new String(cArray2, n11, i3 - n11 + 1);
                        if (EditorManager.isBooleanOptionValue("useTabChar")) {
                            int n14 = string2.length();
                            n11 = ++i3;
                            while (i3 < cArray2.length) {
                                if (cArray2[i3] != ' ') {
                                    n14 += i3 - n11;
                                    break;
                                }
                                ++i3;
                            }
                            --i3;
                            if (n14 > 0) {
                                cArray = new char[n14];
                                int n15 = 0;
                                int n16 = n14 / n8;
                                while (n15 < n16) {
                                    cArray[n15++] = 9;
                                }
                                n16 = n14 % n8;
                                for (int i4 = 0; i4 < n16; ++i4) {
                                    cArray[n15++] = 32;
                                }
                                String string5 = new String(cArray, 0, n15);
                                string4 = String.valueOf(String.valueOf(string4)).concat(String.valueOf(String.valueOf(string5)));
                            }
                        } else {
                            string4 = String.valueOf(String.valueOf(string4)).concat(String.valueOf(String.valueOf(string2)));
                        }
                        document.insertString(n13, string4, null);
                        n13 += string4.length();
                        n11 = i3 + 1;
                        continue block9;
                    }
                    case '|': {
                        String string4 = new String(cArray2, n11, i3 - n11);
                        document.insertString(n13, string4, null);
                        n12 = n13 += string4.length();
                        n11 = i3 + 1;
                        continue block9;
                    }
                    case '\\': {
                        if (i3 + 1 >= cArray2.length || cArray2[i3 + 1] != '|') continue block9;
                        String string4 = new String(cArray2, n11, i3 - n11);
                        string4 = String.valueOf(String.valueOf(string4)).concat(String.valueOf(String.valueOf('|')));
                        document.insertString(n13, string4, null);
                        n13 += string4.length();
                        n11 = ++i3 + 1;
                        continue block9;
                    }
                }
            }
            if (n11 < cArray2.length) {
                String string6 = new String(cArray2, n11, cArray2.length - n11);
                document.insertString(n13, string6, null);
            }
            if (n12 != -1) {
                editorPane.setCaretPosition(n12);
            }
            editorPane.endUndoGroup();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    void a(EditorPane editorPane) {
        this.g = editorPane;
        try {
            String string;
            int n2;
            int n3;
            int n4;
            Document document = editorPane.getDocument();
            Element element = document.getDefaultRootElement();
            this.f = n4 = editorPane.getCaretPosition();
            int n5 = element.getElementIndex(n4);
            Element element2 = element.getElement(n5);
            int n6 = element2.getStartOffset();
            int n7 = element2.getEndOffset();
            Segment segment = new Segment();
            document.getText(n6, n7 - n6, segment);
            int n8 = segment.offset;
            int n9 = segment.offset + segment.count;
            int n10 = n4 - n6 + segment.offset;
            for (n3 = n10 - 1; n3 >= n8; --n3) {
                if (TEMPLATE_DELIMITERS.indexOf(segment.array[n3]) >= 0) {
                    n8 = n3 + 1;
                    break;
                }
                --this.f;
            }
            for (n3 = n10; n3 < n9; ++n3) {
                if (TEMPLATE_DELIMITERS.indexOf(segment.array[n3]) < 0) continue;
                n9 = n3;
                break;
            }
            if ((n2 = Arrays.binarySearch(this.templateMap, string = new String(segment.array, n8, n9 - n8))) >= 0) {
                this.expandTemplate(editorPane, this.templateMap[n2], n8 - segment.offset + n6, n9 - segment.offset + n6);
            } else {
                int n11 = Math.min(-n2 - 1, this.templateMap.length - 1);
                CodeTemplate codeTemplate = this.templateMap[n11];
                if (string.length() > 0 && codeTemplate.getTemplateName().startsWith(string)) {
                    n2 = n11;
                }
                this.doPopup(editorPane, n8 - segment.offset + n6, n9 - segment.offset + n6, n2);
            }
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    PopupController(TemplateSet templateSet) {
        this.templateSet = templateSet;
        this.templateMap = TemplateSet.getTemplates();
    }
}

