/*
 * Decompiled with CFR 0.152.
 */
package com.borland.primetime.node;

import com.borland.primetime.node.DuplicateNodeException;
import com.borland.primetime.node.FolderNode;
import com.borland.primetime.node.LightweightNode;
import com.borland.primetime.node.NodeListener;
import com.borland.primetime.node.Project;
import com.borland.primetime.util.AssertionException;
import com.borland.primetime.util.LocaleSort;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.swing.Icon;

public abstract class Node
implements Comparable {
    private int e = -1;
    protected ArrayList nodeListeners;
    private Node b;
    private int d;
    private Project a;
    public static final Node[] EMPTY_ARRAY = new Node[0];

    public String toString() {
        String string = this.getClass().getName().substring(this.getClass().getName().lastIndexOf(46) + 1);
        if (this.b == null) {
            return String.valueOf(String.valueOf(new StringBuffer("#").append(this.d).append(": ").append(string).append(" \"").append(this.getDisplayName()).append("\"")));
        }
        return String.valueOf(String.valueOf(new StringBuffer("#").append(this.d).append(" in #").append(this.b.d).append(": ").append(string).append(" \"").append(this.getDisplayName()).append("\"")));
    }

    public int hashCode() {
        if (this.e == -1) {
            int n2 = this.a == null ? 0 : this.a.hashCode();
            int n3 = this.b == null ? -1 : this.b.d;
            this.e = n2 ^ n3 ^ this.d;
            if (this.e == -1) {
                this.e = -2;
            }
        }
        return this.e;
    }

    public boolean equals(Object object) {
        return this == object;
    }

    public int compareTo(Object object) {
        String string;
        if (object == null) {
            return 1;
        }
        Node node = (Node)object;
        int n2 = this.getDisplaySequence() - node.getDisplaySequence();
        if (n2 != 0) {
            return n2;
        }
        String string2 = this.getDisplayName();
        if (string2 != (string = node.getDisplayName())) {
            if (string2 == null) {
                return -1;
            }
            if (string == null) {
                return 1;
            }
            int n3 = LocaleSort.collator != null ? LocaleSort.collator.compare(string2, string) : string2.compareToIgnoreCase(string);
            if (n3 != 0) {
                return n3;
            }
        }
        return this.d - node.d;
    }

    int a(Object object) {
        int n2;
        if (object instanceof Integer) {
            int n3;
            int n4 = (Integer)object;
            int n5 = n3 = this.b == null ? Integer.MIN_VALUE : this.b.d;
            if (n3 < n4) {
                return -1;
            }
            return 1;
        }
        Node node = (Node)object;
        Node node2 = node.getParent();
        int n6 = this.b == null ? Integer.MIN_VALUE : this.b.d;
        int n7 = n2 = node2 == null ? Integer.MIN_VALUE : node2.d;
        if (n6 < n2) {
            return -1;
        }
        if (n6 > n2) {
            return 1;
        }
        return this.compareTo(object);
    }

    public synchronized void fireNodeRenamed() {
        if (this.nodeListeners != null) {
            Iterator iterator = ((AbstractList)((ArrayList)this.nodeListeners.clone())).iterator();
            while (iterator.hasNext()) {
                ((NodeListener)iterator.next()).nodeRenamed(this);
            }
        }
        if (this.a != null) {
            this.a.fireNodeChanged(this);
        }
    }

    public synchronized void removeNodeListener(NodeListener nodeListener) {
        if (this.nodeListeners == null) {
            return;
        }
        ((AbstractCollection)this.nodeListeners).remove(nodeListener);
        if (this.nodeListeners.isEmpty()) {
            this.nodeListeners = null;
        }
    }

    public synchronized void addNodeListener(NodeListener nodeListener) {
        if (this.nodeListeners == null) {
            this.nodeListeners = new ArrayList(2);
        }
        this.nodeListeners.add(nodeListener);
    }

    public SortedMap getProperties() {
        return new TreeMap(this.getProject().a(this.d));
    }

    public void setProperty(String string, String string2) {
        this.setProperty("sys", string, string2, null);
    }

    public void setProperty(String string, String string2, String string3) {
        this.setProperty(string, string2, string3, null);
    }

    public synchronized void setProperty(String string, String string2, String string3, String string4) {
        this.getProject().a(this.d, string, string2, string3 == null || string3.equals(string4) ? null : string3, this.d == 0 || this.b != null);
    }

    public String getProperty(String string) {
        return this.getProperty("sys", string, null);
    }

    public String getProperty(String string, String string2) {
        return this.getProperty("sys", string, string2);
    }

    public synchronized String getProperty(String string, String string2, String string3) {
        String string4 = this.getProject().a(this.d, string, string2);
        return string4 == null ? string3 : string4;
    }

    public void makePersistent() {
        if (!this.isPersistent()) {
            FolderNode folderNode = null;
            LightweightNode[] lightweightNodeArray = this.a.findNodes(FolderNode.SETTINGS_FOLDER_NAME);
            for (int i2 = 0; i2 < lightweightNodeArray.length; ++i2) {
                LightweightNode lightweightNode = lightweightNodeArray[i2];
                if (!(lightweightNode instanceof FolderNode) || !lightweightNode.isPersistent()) continue;
                folderNode = (FolderNode)lightweightNodeArray[i2];
            }
            if (folderNode == null) {
                folderNode = new FolderNode(this.a, this.a, FolderNode.SETTINGS_FOLDER_NAME);
            }
            FolderNode.SETTINGS_FOLDER.setBoolean(folderNode, true, false);
            this.setParent(folderNode);
        }
    }

    public void makePersistant() {
        this.makePersistent();
    }

    public boolean isPersistent() {
        if (this.b == null) {
            return false;
        }
        return this.b.isPersistent();
    }

    public boolean isPersistant() {
        return this.isPersistent();
    }

    public boolean hasDisplayChildren() {
        return this.getDisplayChildren().length > 0;
    }

    public Node[] getDisplayChildren() {
        return this.getChildren();
    }

    public boolean hasChildren() {
        return this.getChildren().length > 0;
    }

    public Node[] getChildren() {
        return this.getProject().a(this).toArray(EMPTY_ARRAY);
    }

    public void setParent(Node node) {
        if (this.b == node) {
            return;
        }
        Node node2 = this.b;
        Project project = this.a;
        synchronized (project) {
            if (!this.a.c(this)) {
                throw new AssertionException();
            }
            this.e = -1;
            this.b = node;
            try {
                this.a.b(this);
            }
            catch (DuplicateNodeException duplicateNodeException) {
                duplicateNodeException.printStackTrace(System.err);
                throw new AssertionException();
            }
        }
        if (node2 != null) {
            this.a.fireChildrenChanged(node2);
        }
        if (node != null) {
            this.a.fireChildrenChanged(node);
        }
    }

    public Node getParent() {
        return this.b;
    }

    public void dumpNodes() {
        this.dumpNodes(false);
    }

    public void dumpNodes(boolean bl) {
        System.out.println(String.valueOf(String.valueOf(new StringBuffer("--- ").append(this).append(" dumpNodes() ---"))));
        this.dumpNodes("", bl);
    }

    public void dumpNodes(String string, boolean bl) {
        Node[] nodeArray = bl ? this.getDisplayChildren() : this.getChildren();
        for (int i2 = 0; i2 < nodeArray.length; ++i2) {
            System.out.println(String.valueOf(String.valueOf(new StringBuffer(" ").append(string).append(nodeArray[i2]))));
            nodeArray[i2].dumpNodes(String.valueOf(String.valueOf(string)).concat(" "), bl);
        }
    }

    public void check() {
    }

    public int getNodeID() {
        return this.d;
    }

    public boolean isModified() {
        return false;
    }

    public Project getProject() {
        return this.a;
    }

    public int getDisplaySequence() {
        return 400;
    }

    public String getLongDisplayName() {
        return this.getDisplayName();
    }

    public abstract String getDisplayName();

    public abstract Icon getDisplayIcon();

    Node(Project project, Node node) {
        this.a = project;
        this.b = node;
        this.d = project.d();
    }

    Node() {
    }
}

