/*
 * Decompiled with CFR 0.152.
 */
package com.borland.primetime.printer;

import com.borland.primetime.editor.EditorDocument;
import com.borland.primetime.editor.EditorManager;
import com.borland.primetime.editor.EditorPane;
import com.borland.primetime.editor.LineMark;
import com.borland.primetime.editor.MasterStyleContext;
import com.borland.primetime.ide.Browser;
import com.borland.primetime.printer.EditorPrintSettings;
import com.borland.primetime.printer.c;
import com.borland.primetime.printer.d;
import com.borland.primetime.util.Platform;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.io.File;
import java.text.DateFormat;
import java.util.Date;
import java.util.TimeZone;
import java.util.Vector;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.Segment;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.TabExpander;
import javax.swing.text.Utilities;

public class EditorPagePrinter
implements TabExpander,
Printable,
Pageable {
    String b;
    String d;
    String c;
    protected int centerMargin = 2;
    protected boolean headerTitleEnabled = true;
    protected int callCounter = 0;
    protected boolean showHeadersOnFirstPageOnly;
    protected boolean drawBorderEnabled = true;
    protected boolean printOnlySelectedTextEnabled = true;
    protected int lineNumberingInterval;
    protected boolean useSmartWrapping;
    protected boolean showWraparoundSymbol = true;
    protected int pagesPerSheet;
    protected Color lineNumberColor;
    protected FontMetrics headerFontMetrics;
    protected FontMetrics codeFontMetrics;
    protected String filename = "";
    protected static final int LINE_NUMBERING_GAP = 6;
    protected Vector pageInfoVector;
    protected static PageFormat pageFormat = new PageFormat();
    protected boolean colorEnabled;
    protected boolean sectionNumberingEnabled;
    protected boolean lineWrapEnabled;
    protected boolean lineNumberingEnabled;
    protected boolean headerEnabled;
    protected String jobName;
    protected String headerFontName;
    protected String codeFontName;
    protected int headerFontSize;
    protected int codeFontSize;
    protected boolean syntaxPrintEnabled;
    protected int headerHeight;
    protected int charWidth;
    private Color j;
    protected Color headerShadingColor;
    protected boolean headerShading;
    protected boolean firstPage = true;
    protected int currentLineInPageCount = 0;
    protected int pageIndex = 0;
    protected Segment lineBuffer = new Segment();
    protected int tabBase;
    protected int numPages;
    protected EditorPane editor;
    protected int lineCountForOtherPages = 0;
    protected int lineCountForFirstPage = 0;
    protected int maxPrintedCharsPerLine = 0;

    static {
        LINE_NUMBERING_GAP = 6;
    }

    public float nextTabStop(float f2, int n2) {
        int n3 = EditorManager.getTabSize();
        return f2 + (float)(n3 * this.charWidth);
    }

    protected void drawLineOnPage(Graphics graphics, EditorDocument.StyledLeafElement styledLeafElement, int n2, int n3) throws BadLocationException {
        EditorDocument editorDocument = (EditorDocument)this.editor.getDocument();
        MasterStyleContext masterStyleContext = EditorManager.getStyleContext();
        int n4 = this.getLineXPos(this.currentLineInPageCount) + this.getLineNumberingWidth();
        int n5 = n2;
        while (n5 < n3) {
            int n6 = styledLeafElement.getEndOfRun(n5);
            n6 = n6 <= n3 && n6 != -1 ? n6 : n3;
            Segment segment = this.lineBuffer;
            editorDocument.getText(n5, n6 - n5, segment);
            Style style = styledLeafElement.getStyle(n5);
            if (this.isColorEnabled()) {
                Color color = StyleConstants.getForeground(style);
                if (color.getRGB() == Color.white.getRGB()) {
                    color = Color.black;
                }
                graphics.setColor(color);
            } else {
                graphics.setColor(Color.black);
            }
            int n7 = masterStyleContext.getFont(style).getStyle();
            if (!this.isSyntaxPrintEnabled()) {
                n7 = 0;
            }
            Font font = new Font(this.getCodeFontName(), n7, this.getCodeFontSize());
            graphics.setFont(font);
            n4 = Utilities.drawTabbedText(segment, n4, this.getLineYPos(this.currentLineInPageCount), graphics, (TabExpander)this, n5);
            n5 = n6;
        }
        ++this.currentLineInPageCount;
    }

    protected boolean isFirstPage() {
        return this.pageIndex == 0 || this.callCounter < 3;
    }

    protected int whichSectionInPage(int n2) {
        int n3 = this.a(this.isFirstPage());
        int n4 = 1 + n2 / (n3 / this.getSectionsPerPage());
        if (n4 > this.getSectionsPerPage()) {
            n4 = this.getSectionsPerPage();
        }
        return n4;
    }

    protected int getXOrigin(int n2) {
        int n3 = (int)pageFormat.getImageableX();
        block0 : switch (this.getSectionsPerPage()) {
            case 0: 
            case 1: {
                n3 = (int)pageFormat.getImageableX() + 1;
                break;
            }
            case 2: {
                switch (this.whichSectionInPage(n2)) {
                    case 1: {
                        n3 = (int)pageFormat.getImageableX() + 1;
                        break;
                    }
                    case 2: {
                        n3 = (int)pageFormat.getImageableX() + ((int)pageFormat.getImageableWidth() + this.getCenterMarginWidth()) / 2;
                    }
                }
                break;
            }
            case 3: {
                switch (this.whichSectionInPage(n2)) {
                    case 1: {
                        n3 = (int)pageFormat.getImageableX() + 1;
                        break;
                    }
                    case 2: {
                        n3 = (int)pageFormat.getImageableX() + (int)pageFormat.getImageableWidth() * 1 / 3 + this.getCenterMarginWidth() / 2;
                        break;
                    }
                    case 3: {
                        n3 = (int)pageFormat.getImageableX() + (int)pageFormat.getImageableWidth() * 2 / 3 + this.getCenterMarginWidth() / 2;
                    }
                }
                break;
            }
            case 4: {
                switch (this.whichSectionInPage(n2)) {
                    case 1: 
                    case 3: {
                        n3 = (int)pageFormat.getImageableX() + 1;
                        break;
                    }
                    case 2: 
                    case 4: {
                        n3 = (int)pageFormat.getImageableX() + ((int)pageFormat.getImageableWidth() + this.getCenterMarginWidth()) / 2;
                    }
                }
                break;
            }
            case 6: {
                switch (this.whichSectionInPage(n2)) {
                    case 1: 
                    case 4: {
                        n3 = (int)pageFormat.getImageableX() + 1;
                        break;
                    }
                    case 2: 
                    case 5: {
                        n3 = (int)pageFormat.getImageableX() + (int)pageFormat.getImageableWidth() * 1 / 3 + this.getCenterMarginWidth() / 2;
                        break;
                    }
                    case 3: 
                    case 6: {
                        n3 = (int)pageFormat.getImageableX() + (int)pageFormat.getImageableWidth() * 2 / 3 + this.getCenterMarginWidth() / 2;
                    }
                }
                break;
            }
            case 8: {
                switch (this.whichSectionInPage(n2)) {
                    case 1: 
                    case 5: {
                        n3 = (int)pageFormat.getImageableX() + 1;
                        break block0;
                    }
                    case 2: 
                    case 6: {
                        n3 = (int)pageFormat.getImageableX() + (int)pageFormat.getImageableWidth() / 4 + this.getCenterMarginWidth() / 2;
                        break block0;
                    }
                    case 3: 
                    case 7: {
                        n3 = (int)pageFormat.getImageableX() + (int)pageFormat.getImageableWidth() / 2 + this.getCenterMarginWidth() / 2;
                        break block0;
                    }
                    case 4: 
                    case 8: {
                        n3 = (int)pageFormat.getImageableX() + (int)pageFormat.getImageableWidth() * 3 / 4 + this.getCenterMarginWidth() / 2;
                    }
                }
            }
        }
        return n3;
    }

    protected int getLineXPos(int n2) {
        return this.getXOrigin(n2);
    }

    protected int getLineYPos(int n2) {
        int n3 = this.a(this.isFirstPage());
        int n4 = n3 / this.getSectionsPerPage();
        int n5 = n2 - n4 * (this.whichSectionInPage(n2) - 1);
        int n6 = n5 * this.b(this.codeFontMetrics);
        return n6 + this.getYOrigin(n2);
    }

    protected int getYOrigin(int n2) {
        int n3 = 0;
        block0 : switch (this.getSectionsPerPage()) {
            case 1: 
            case 2: 
            case 3: {
                n3 = this.b(this.isFirstPage()) + (int)pageFormat.getImageableY();
                break;
            }
            case 4: {
                switch (this.whichSectionInPage(n2)) {
                    case 1: 
                    case 2: {
                        n3 = this.b(this.isFirstPage()) + (int)pageFormat.getImageableY();
                        break;
                    }
                    case 3: 
                    case 4: {
                        int n4 = this.b(this.isFirstPage());
                        int n5 = (int)pageFormat.getImageableHeight() - n4;
                        n3 = (int)pageFormat.getImageableY() + n4 + n5 / 2 + this.getCenterMarginHeight() / 2 - this.codeFontMetrics.getDescent();
                    }
                }
                break;
            }
            case 6: {
                switch (this.whichSectionInPage(n2)) {
                    case 1: 
                    case 2: 
                    case 3: {
                        n3 = this.b(this.isFirstPage()) + (int)pageFormat.getImageableY();
                        break block0;
                    }
                    case 4: 
                    case 5: 
                    case 6: {
                        int n6 = this.b(this.isFirstPage());
                        int n7 = (int)pageFormat.getImageableHeight() - n6;
                        n3 = (int)pageFormat.getImageableY() + n6 + n7 / 2 + this.getCenterMarginHeight() / 2 - this.codeFontMetrics.getDescent();
                        break block0;
                    }
                }
                break;
            }
            case 8: {
                switch (this.whichSectionInPage(n2)) {
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: {
                        n3 = this.b(this.isFirstPage()) + (int)pageFormat.getImageableY();
                        break block0;
                    }
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: {
                        int n8 = this.b(this.isFirstPage());
                        int n9 = (int)pageFormat.getImageableHeight() - n8;
                        n3 = (int)pageFormat.getImageableY() + n8 + n9 / 2 + this.getCenterMarginHeight() / 2 - this.codeFontMetrics.getDescent();
                        break block0;
                    }
                }
                break;
            }
        }
        return n3 += this.b(this.codeFontMetrics);
    }

    private int a(FontMetrics fontMetrics) {
        return fontMetrics.charWidth('X');
    }

    public void setLineNumberingEnabled(boolean bl) {
        this.lineNumberingEnabled = bl;
    }

    public boolean isLineNumberingEnabled() {
        return this.lineNumberingEnabled;
    }

    public boolean isLineWrapEnabled() {
        return this.lineWrapEnabled;
    }

    public void setLineWrapEnabled(boolean bl) {
        this.lineWrapEnabled = bl;
    }

    public void setColorEnabled(boolean bl) {
        this.colorEnabled = bl;
    }

    public boolean isColorEnabled() {
        return this.colorEnabled;
    }

    public Color getLineNumberColor() {
        return this.lineNumberColor;
    }

    public void setLineNumberColor(Color color) {
        this.lineNumberColor = color;
    }

    private void a(Graphics graphics, int n2, int n3) {
        Font font = graphics.getFont();
        Color color = graphics.getColor();
        if (this.isColorEnabled()) {
            Color color2 = this.getLineNumberColor();
        } else {
            Color color3 = Color.black;
        }
        if (this.isColorEnabled()) {
            graphics.setColor(this.getLineNumberColor());
        }
        StringBuffer stringBuffer = new StringBuffer("");
        if (Platform.WIN32) {
            graphics.setFont(new Font("ZapfDingbats", 0, this.getCodeFontSize()));
            stringBuffer.append('\u00c3');
        } else {
            graphics.setFont(new Font("Monospaced", 0, this.getCodeFontSize()));
            stringBuffer.append("\\");
        }
        graphics.drawString(stringBuffer.toString(), n2 - 2, n3);
        graphics.setFont(font);
        graphics.setColor(color);
    }

    protected void drawHeader(Graphics graphics, PageFormat pageFormat, int n2) {
        int n3 = (int)pageFormat.getImageableX();
        int n4 = (int)pageFormat.getImageableY();
        int n5 = (int)pageFormat.getImageableWidth();
        graphics.setFont(new Font(this.getHeaderFontName(), 1, this.getHeaderFontSize()));
        String string = " ";
        if (this.isHeaderShadingEnabled()) {
            graphics.setColor(this.getHeaderShadingColor());
            graphics.fillRect(n3, n4, n5 - 1, this.getHeaderHeight());
        }
        graphics.setColor(Color.black);
        graphics.drawRect(n3, n4, n5 - 1, this.getHeaderHeight());
        graphics.setColor(Color.black);
        String string2 = String.valueOf(String.valueOf(this.formatHeaders(n2, this.getUnFormattedPageHeader()))).concat(String.valueOf(String.valueOf(string)));
        graphics.drawString(string2, n3 + (n5 - 3) - this.getHeaderFontMetrics().stringWidth(string2), n4 + this.getHeaderHeight() - this.getHeaderFontMetrics().getDescent());
        if (this.isHeaderTitleEnabled()) {
            graphics.drawString(String.valueOf(String.valueOf(string)).concat(String.valueOf(String.valueOf(this.formatHeaders(n2, this.getUnFormattedTitleHeader())))), n3, n4 + this.getHeaderFontMetrics().getAscent());
        }
        String string3 = String.valueOf(String.valueOf(string)).concat(String.valueOf(String.valueOf(this.formatHeaders(n2, this.getUnFormattedDateHeader()))));
        graphics.drawString(string3, n3, n4 + this.getHeaderHeight() - this.getHeaderFontMetrics().getDescent());
    }

    protected void drawBorder(Graphics graphics, PageFormat pageFormat) {
        int n2 = (int)pageFormat.getImageableX();
        int n3 = (int)pageFormat.getImageableY();
        int n4 = (int)pageFormat.getImageableWidth();
        int n5 = (int)pageFormat.getImageableHeight();
        graphics.setColor(Color.black);
        graphics.drawRect(n2, n3, n4 - 1, n5);
    }

    private void a(Graphics graphics, int n2) {
        int n3 = Integer.toString(n2 * this.getSectionsPerPage()).length();
        int n4 = this.codeFontMetrics.charWidth('X') * n3;
        int n5 = (int)pageFormat.getImageableX();
        int n6 = (int)pageFormat.getImageableY();
        int n7 = (int)pageFormat.getImageableWidth() - 1;
        int n8 = (int)pageFormat.getImageableHeight() - 1;
        int n9 = 2;
        int n10 = 4;
        int n11 = this.codeFontMetrics.getAscent() + 1;
        int n12 = this.b(this.isFirstPage());
        Color color = graphics.getColor();
        switch (this.getSectionsPerPage()) {
            case 1: {
                return;
            }
            case 2: {
                int n13 = n6 + n8 - n11 - 1;
                int n14 = 2 * n2 - 2;
                for (int i2 = 1; i2 <= 3; ++i2) {
                    ++n14;
                    int n15 = n5 + i2 * n7 / 2 - n4;
                    graphics.setColor(this.j);
                    graphics.fillRect(n15 - 2, n13, n4 + 2, n11 + 1);
                    graphics.setColor(Color.black);
                    graphics.drawRect(n15 - 2, n13, n4 + 2, n11 + 1);
                    graphics.drawString(Integer.toString(n14), n15, n13 + n11);
                }
                graphics.setColor(color);
                return;
            }
            case 3: {
                int n16 = n6 + n8 - n11 - 1;
                int n17 = 3 * n2 - 3;
                for (int i3 = 1; i3 <= 3; ++i3) {
                    ++n17;
                    int n18 = n5 + i3 * n7 / 3 - n4;
                    graphics.setColor(this.j);
                    graphics.fillRect(n18 - 2, n16, n4 + 2, n11 + 1);
                    graphics.setColor(Color.black);
                    graphics.drawRect(n18 - 2, n16, n4 + 2, n11 + 1);
                    graphics.drawString(Integer.toString(n17), n18, n16 + n11);
                }
                graphics.setColor(color);
                return;
            }
            case 6: {
                int n19;
                int n20;
                int n21 = n6 + n12 + (n8 - n12) / 2 - n11 - 1;
                int n22 = 6 * n2 - 6;
                for (n20 = 1; n20 <= 3; ++n20) {
                    ++n22;
                    n19 = n5 + n20 * n7 / 3 - n4;
                    graphics.setColor(this.j);
                    graphics.fillRect(n19 - 2, n21, n4 + 2, n11 + 1);
                    graphics.setColor(Color.black);
                    graphics.drawRect(n19 - 2, n21, n4 + 2, n11 + 1);
                    graphics.drawString(Integer.toString(n22), n19, n21 + n11);
                }
                n21 = n6 + n8 - n11 - 1;
                for (n20 = 1; n20 <= 3; ++n20) {
                    ++n22;
                    n19 = n5 + n20 * n7 / 3 - n4;
                    graphics.setColor(this.j);
                    graphics.fillRect(n19 - 2, n21, n4 + 2, n11 + 1);
                    graphics.setColor(Color.black);
                    graphics.drawRect(n19 - 2, n21, n4 + 2, n11 + 1);
                    graphics.drawString(Integer.toString(n22), n19, n21 + n11);
                }
                graphics.setColor(color);
                return;
            }
            case 8: {
                int n23;
                int n24;
                int n25 = n6 + n12 + (n8 - n12) / 2 - n11 - 1;
                int n26 = 8 * n2 - 8;
                for (n24 = 1; n24 <= 4; ++n24) {
                    ++n26;
                    n23 = n5 + n24 * n7 / 4 - n4;
                    graphics.setColor(this.j);
                    graphics.fillRect(n23 - 2, n25, n4 + 2, n11 + 1);
                    graphics.setColor(Color.black);
                    graphics.drawRect(n23 - 2, n25, n4 + 2, n11 + 1);
                    graphics.drawString(Integer.toString(n26), n23, n25 + n11);
                }
                n25 = n6 + n8 - n11 - 1;
                for (n24 = 1; n24 <= 4; ++n24) {
                    ++n26;
                    n23 = n5 + n24 * n7 / 4 - n4;
                    graphics.setColor(this.j);
                    graphics.fillRect(n23 - 2, n25, n4 + 2, n11 + 1);
                    graphics.setColor(Color.black);
                    graphics.drawRect(n23 - 2, n25, n4 + 2, n11 + 1);
                    graphics.drawString(Integer.toString(n26), n23, n25 + n11);
                }
                graphics.setColor(color);
                return;
            }
        }
    }

    private void b(Graphics graphics, PageFormat pageFormat, int n2) {
        int n3 = (int)pageFormat.getImageableX();
        int n4 = (int)pageFormat.getImageableY();
        int n5 = (int)pageFormat.getImageableWidth() - 1;
        int n6 = (int)pageFormat.getImageableHeight() - 1;
        int n7 = this.b(this.isFirstPage());
        graphics.setColor(Color.black);
        switch (n2) {
            case 2: {
                graphics.drawLine(n3 + n5 / 2, n4 + n7, n3 + n5 / 2, n7 + n6 + n4);
                break;
            }
            case 3: {
                graphics.drawLine(n3 + n5 / 3, n4 + n7, n3 + n5 / 3, n7 + n6 + n4);
                graphics.drawLine(n3 + n5 * 2 / 3, n4 + this.getHeaderHeight(), n3 + n5 * 2 / 3, n7 + n6 + n4);
                break;
            }
            case 4: {
                graphics.drawLine(n3 + n5 / 2, n4 + n7, n3 + n5 / 2, n7 + n6 + n4);
                graphics.drawLine(n3, n4 + n7 + (n6 - n7) / 2, n3 + n5, n4 + n7 + (n6 - n7) / 2);
                break;
            }
            case 6: {
                graphics.drawLine(n3 + n5 / 3, n4 + n7, n3 + n5 / 3, n7 + n6 + n4);
                graphics.drawLine(n3 + n5 * 2 / 3, n4 + this.getHeaderHeight(), n3 + n5 * 2 / 3, n7 + n6 + n4);
                graphics.drawLine(n3, n4 + n7 + (n6 - n7) / 2, n3 + n5, n4 + n7 + (n6 - n7) / 2);
                break;
            }
            case 8: {
                graphics.drawLine(n3 + n5 / 2, n4 + this.getHeaderHeight(), n3 + n5 / 2, n7 + n6 + n4);
                graphics.drawLine(n3 + n5 / 4, n4 + this.getHeaderHeight(), n3 + n5 / 4, n7 + n6 + n4);
                graphics.drawLine(n3 + n5 * 3 / 4, n4 + this.getHeaderHeight(), n3 + n5 * 3 / 4, n7 + n6 + n4);
                graphics.drawLine(n3, n4 + n7 + (n6 - n7) / 2, n3 + n5, n4 + n7 + (n6 - n7) / 2);
                break;
            }
        }
    }

    protected void updateHeaderFontMetrics() {
        Font font = new Font(this.headerFontName, 1, this.getHeaderFontSize());
        this.headerFontMetrics = ((Component)this.editor).getFontMetrics(font);
    }

    public FontMetrics getHeaderFontMetrics() {
        return this.headerFontMetrics;
    }

    public void setHeaderFontSize(int n2) {
        this.headerFontSize = n2;
        this.updateHeaderFontMetrics();
    }

    public int getHeaderFontSize() {
        return this.headerFontSize;
    }

    public void setHeaderFontName(String string) {
        this.headerFontName = string;
        this.updateHeaderFontMetrics();
    }

    public String getHeaderFontName() {
        return this.headerFontName;
    }

    public void updateCodeFontMetrics() {
        Font font = new Font(this.codeFontName, 1, this.getCodeFontSize());
        this.codeFontMetrics = ((Component)this.editor).getFontMetrics(font);
    }

    public FontMetrics getCodeFontMetrics() {
        return this.codeFontMetrics;
    }

    public void setCodeFontSize(int n2) {
        this.codeFontSize = n2;
        this.updateCodeFontMetrics();
    }

    public int getCodeFontSize() {
        return this.codeFontSize;
    }

    public void setCodeFontName(String string) {
        this.codeFontName = string;
        this.updateCodeFontMetrics();
    }

    public String getCodeFontName() {
        return this.codeFontName;
    }

    public Color getHeaderShadingColor() {
        return this.headerShadingColor;
    }

    public void setHeaderShadingColor(Color color) {
        this.headerShadingColor = color;
    }

    public void setHeaderShadingEnabled(boolean bl) {
        this.headerShading = bl;
    }

    public boolean isHeaderShadingEnabled() {
        return this.headerShading;
    }

    public int calculateNumberOfPages() {
        Object object;
        int n2;
        int n3;
        boolean bl = false;
        int n4 = this.a(true);
        Document document = this.editor.getDocument();
        Element element = document.getDefaultRootElement();
        int n5 = 0;
        this.pageInfoVector = new Vector();
        int n6 = this.calculateMaxCharsPerLine();
        int n7 = 0;
        boolean bl2 = false;
        if (this.isPrintOnlySelectedTextEnabled()) {
            n3 = this.b(this.editor.getSelectionStart());
            n2 = this.b(this.editor.getSelectionEnd()) - n3;
            if (n2 == 0) {
                n3 = 0;
                n2 = element.getElementCount();
            }
            n2 = n3 + n2;
        } else {
            n3 = 0;
            n2 = element.getElementCount();
        }
        int n8 = n3;
        while (n3 < n2) {
            n7 = 0;
            EditorDocument.StyledLeafElement styledLeafElement = (EditorDocument.StyledLeafElement)element.getElement(n3);
            int n9 = this.deTabify(styledLeafElement.getText()).length();
            if (n9 > n6 && this.isLineWrapEnabled()) {
                object = this.deTabify(styledLeafElement.getText());
                ++n5;
                ++n7;
                while (((String)object).length() > n6) {
                    int n10 = this.a((String)object, n6);
                    object = ((String)object).substring(n10);
                    ++n5;
                    ++n7;
                }
            } else {
                ++n5;
            }
            if (n5 > n4) {
                object = new d(n8, n3);
                this.pageInfoVector.addElement(object);
                n8 = n3;
                n5 = 0;
                n4 = this.a(false);
                continue;
            }
            ++n3;
        }
        if (n3 > n8) {
            object = new d(n8, n3);
            this.pageInfoVector.addElement(object);
        }
        this.numPages = this.pageInfoVector.size();
        return this.numPages;
    }

    public String deTabify(String string) {
        if (string.indexOf(9) == -1) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = EditorManager.getTabSize();
        int n3 = 0;
        for (int i2 = 0; i2 < string.length(); ++i2) {
            if (string.charAt(i2) != '\t') {
                stringBuffer.append(string.charAt(i2));
                ++n3;
                continue;
            }
            int n4 = n3 % n2;
            if (n4 == 0) {
                n4 = n2;
            }
            for (int i3 = 0; i3 < n4; ++i3) {
                stringBuffer.append(' ');
                ++n3;
            }
        }
        return stringBuffer.toString();
    }

    private int a(boolean bl) {
        if (bl) {
            if (this.lineCountForFirstPage > 0) {
                return this.lineCountForFirstPage;
            }
        } else if (this.lineCountForOtherPages > 0) {
            return this.lineCountForOtherPages;
        }
        int n2 = this.b(bl);
        int n3 = 0;
        switch (this.getSectionsPerPage()) {
            case 1: {
                n3 = ((int)pageFormat.getImageableHeight() - n2) / this.b(this.codeFontMetrics);
                break;
            }
            case 2: 
            case 3: {
                n3 = this.getSectionsPerPage() * ((int)pageFormat.getImageableHeight() - n2) / this.b(this.codeFontMetrics) - this.getSectionsPerPage() * this.getCenterMargin();
                break;
            }
            default: {
                int n4 = this.getSectionsPerPage() / 2;
                n3 = ((int)pageFormat.getImageableHeight() - n2) / this.b(this.codeFontMetrics);
                n3 = n3 * n4 - n4 * this.getCenterMargin();
            }
        }
        if (bl) {
            this.lineCountForFirstPage = n3;
        } else {
            this.lineCountForOtherPages = n3;
        }
        return n3;
    }

    private int b(boolean bl) {
        int n2 = this.isHeaderEnabled() && this.isHeaderOnFirstPageOnlyEnabled() && !bl ? 0 : this.getHeaderHeight();
        return n2;
    }

    private int b(int n2) {
        EditorDocument.StyledLeafElement styledLeafElement;
        int n3;
        Document document = this.editor.getDocument();
        Element element = document.getDefaultRootElement();
        int n4 = element.getElementCount();
        int n5 = 0;
        for (n3 = 0; n3 < n4 && (n5 += (styledLeafElement = (EditorDocument.StyledLeafElement)element.getElement(n3)).getText().length()) <= n2; ++n3) {
        }
        return n3;
    }

    protected int getHeaderHeight() {
        if (this.isHeaderEnabled()) {
            if (this.isHeaderTitleEnabled()) {
                return 2 * this.b(this.getHeaderFontMetrics());
            }
            return this.b(this.getHeaderFontMetrics());
        }
        return 0;
    }

    private int a(String string, int n2) {
        int n3 = string.length();
        if (n3 <= n2) {
            return string.length() - 1;
        }
        if (this.isSmartWrappingEnabled()) {
            int n4;
            boolean bl = false;
            boolean bl2 = false;
            int n5 = n4 = this.showWraparoundSymbol ? 1 : 0;
            while (n4 < 20 && n4 < n2) {
                char c2 = string.charAt(n2 - n4);
                if (c2 == ' ' || c2 == '\t') {
                    bl = true;
                    break;
                }
                if (c2 == ',' || c2 == '+' || c2 == ')' || c2 == '=' || c2 == '-' || c2 == '*') {
                    bl2 = true;
                    break;
                }
                ++n4;
            }
            if (!bl2 && !bl) {
                if (this.isWrapAroundSymbolEnabled()) {
                    return n2 - 1;
                }
                return n2;
            }
            if (bl) {
                return n2 - n4 + 1;
            }
            return n2 - n4;
        }
        if (this.isWrapAroundSymbolEnabled()) {
            return n2 - 1;
        }
        return n2;
    }

    private String a(int n2) {
        if (n2 % this.getLineNumberingInterval() != 0) {
            return "    ";
        }
        String string = Integer.toString(n2);
        switch (string.length()) {
            case 0: {
                return "????";
            }
            case 1: {
                return "   ".concat(String.valueOf(String.valueOf(string)));
            }
            case 2: {
                return "  ".concat(String.valueOf(String.valueOf(string)));
            }
            case 3: {
                return " ".concat(String.valueOf(String.valueOf(string)));
            }
            case 4: {
                return string;
            }
        }
        return string.substring(0, 3);
    }

    private int b(FontMetrics fontMetrics) {
        return fontMetrics.getAscent() + fontMetrics.getDescent();
    }

    protected int getLineNumberingWidth() {
        if (this.isLineNumberingEnabled()) {
            this.charWidth = this.codeFontMetrics.charWidth('X');
            return this.charWidth * 6;
        }
        return 0;
    }

    protected int calculateMaxCharsPerLine() {
        if (this.maxPrintedCharsPerLine > 0) {
            return this.maxPrintedCharsPerLine;
        }
        this.charWidth = this.codeFontMetrics.charWidth('X');
        int n2 = 0;
        switch (this.getSectionsPerPage()) {
            case 1: {
                n2 = ((int)pageFormat.getImageableWidth() - this.getLineNumberingWidth()) / this.charWidth;
                break;
            }
            case 2: 
            case 4: {
                int n3 = this.getCenterMarginWidth();
                int n4 = ((int)pageFormat.getImageableWidth() - n3) / 2;
                int n5 = n4 - this.getLineNumberingWidth();
                n2 = n5 / this.charWidth;
                break;
            }
            case 3: 
            case 6: {
                int n6 = this.getCenterMarginWidth() * 2;
                int n7 = ((int)pageFormat.getImageableWidth() - n6) / 3;
                int n8 = n7 - this.getLineNumberingWidth();
                n2 = n8 / this.charWidth;
                break;
            }
            case 8: {
                int n9 = this.getCenterMarginWidth() * 3;
                int n10 = ((int)pageFormat.getImageableWidth() - n9) / 4;
                int n11 = n10 - this.getLineNumberingWidth();
                n2 = n11 / this.charWidth;
            }
        }
        this.maxPrintedCharsPerLine = n2;
        return n2;
    }

    public void setHeaderEnabled(boolean bl) {
        this.headerEnabled = bl;
    }

    public void setSmartWrappingEnabled(boolean bl) {
        this.useSmartWrapping = bl;
    }

    public boolean isSmartWrappingEnabled() {
        return this.useSmartWrapping;
    }

    public boolean isHeaderEnabled() {
        return this.headerEnabled;
    }

    public int getSectionsPerPage() {
        return this.pagesPerSheet;
    }

    public void setPagesPerSheet(int n2) {
        this.pagesPerSheet = n2;
    }

    public void setSyntaxPrintEnabled(boolean bl) {
        this.syntaxPrintEnabled = bl;
    }

    public boolean isWrapAroundSymbolEnabled() {
        return this.showWraparoundSymbol;
    }

    public void setWrapAroundSymbolEnabled(boolean bl) {
        this.showWraparoundSymbol = bl;
    }

    public void setLineNumberingInterval(int n2) {
        this.lineNumberingInterval = n2;
    }

    public int getLineNumberingInterval() {
        return this.lineNumberingInterval;
    }

    public boolean isSyntaxPrintEnabled() {
        return this.syntaxPrintEnabled;
    }

    public void setDrawBorderEnabled(boolean bl) {
        this.drawBorderEnabled = bl;
    }

    public void setSectionNumberingEnabled(boolean bl) {
        this.sectionNumberingEnabled = bl;
    }

    public boolean isSectionNumberingEnabled() {
        return this.sectionNumberingEnabled;
    }

    public boolean isDrawBorderEnabled() {
        return this.drawBorderEnabled;
    }

    public void enablePrintOnlySelectedText(boolean bl) {
        this.printOnlySelectedTextEnabled = bl;
    }

    public boolean isPrintOnlySelectedTextEnabled() {
        return this.printOnlySelectedTextEnabled;
    }

    public String getFilename() {
        if (this.filename == null) {
            this.filename = Browser.getActiveBrowser().getActiveNode().getLongDisplayName();
        }
        return this.filename;
    }

    public String formatHeaders(int n2, String string) {
        String string2;
        File file = new File(this.getFilename());
        int n3 = string.indexOf("%p");
        while (n3 >= 0) {
            string = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(string.substring(0, n3)))).append(Integer.toString(n2 + 1)).append(string.substring(n3 + 2))));
            n3 = string.indexOf("%p");
        }
        n3 = string.indexOf("%n");
        while (n3 >= 0) {
            string = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(string.substring(0, n3)))).append(Integer.toString(this.getNumberOfPages())).append(string.substring(n3 + 2))));
            n3 = string.indexOf("%n");
        }
        n3 = string.indexOf("%f");
        while (n3 >= 0) {
            string = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(string.substring(0, n3)))).append(this.getFilename()).append(string.substring(n3 + 2))));
            n3 = string.indexOf("%f");
        }
        n3 = string.indexOf("%g");
        while (n3 >= 0) {
            string2 = file.getName();
            if (string2 == null) {
                string2 = com.borland.primetime.printer.c.a(104);
            }
            string = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(string.substring(0, n3)))).append(file.getName()).append(string.substring(n3 + 2))));
            n3 = string.indexOf("%g");
        }
        n3 = string.indexOf("%u");
        string2 = System.getProperties().getProperty("user.name");
        if (string2 == null) {
            string2 = com.borland.primetime.printer.c.a(103);
        }
        while (n3 >= 0) {
            string = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(string.substring(0, n3)))).append(string2).append(string.substring(n3 + 2))));
            n3 = string.indexOf("%u");
        }
        DateFormat dateFormat = DateFormat.getDateInstance(1);
        dateFormat.setTimeZone(TimeZone.getDefault());
        String string3 = dateFormat.format(new Date());
        dateFormat = DateFormat.getTimeInstance(3);
        dateFormat.setTimeZone(TimeZone.getDefault());
        String string4 = dateFormat.format(new Date());
        dateFormat = DateFormat.getDateInstance(3);
        String string5 = dateFormat.format(new Date());
        n3 = string.indexOf("%d");
        while (n3 >= 0) {
            string = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(string.substring(0, n3)))).append(string3).append(string.substring(n3 + 2))));
            n3 = string.indexOf("%d");
        }
        n3 = string.indexOf("%s");
        while (n3 >= 0) {
            string = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(string.substring(0, n3)))).append(string5).append(string.substring(n3 + 2))));
            n3 = string.indexOf("%s");
        }
        n3 = string.indexOf("%t");
        while (n3 >= 0) {
            string = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(string.substring(0, n3)))).append(string4).append(string.substring(n3 + 2))));
            n3 = string.indexOf("%t");
        }
        return string;
    }

    public void setUnFormattedTitleHeader(String string) {
        this.b = string;
    }

    public String getUnFormattedTitleHeader() {
        return this.b;
    }

    public void setUnFormattedDateHeader(String string) {
        this.d = string;
    }

    public String getUnFormattedDateHeader() {
        return this.d;
    }

    public void setUnFormattedPageHeader(String string) {
        this.c = string;
    }

    public String getUnFormattedPageHeader() {
        return this.c;
    }

    public int getCenterMarginHeight() {
        return this.centerMargin * this.b(this.codeFontMetrics);
    }

    public int getCenterMarginWidth() {
        return this.centerMargin * this.codeFontMetrics.charWidth('X');
    }

    public int getCenterMargin() {
        return this.centerMargin;
    }

    public void setCenterMargin(int n2) {
        this.centerMargin = n2;
    }

    public void setHeaderOnFirstPageOnlyEnabled(boolean bl) {
        this.showHeadersOnFirstPageOnly = bl;
    }

    public boolean isHeaderOnFirstPageOnlyEnabled() {
        return this.showHeadersOnFirstPageOnly;
    }

    public void setHeaderTitleEnabled(boolean bl) {
        this.headerTitleEnabled = bl;
    }

    public boolean isHeaderTitleEnabled() {
        return this.headerTitleEnabled;
    }

    protected int drawLineFromEditor(int n2, Graphics graphics) {
        try {
            Object object;
            int n3;
            EditorDocument editorDocument = (EditorDocument)this.editor.getDocument();
            Style style = editorDocument.getStyleMap().getStyle(15);
            Style style2 = editorDocument.getStyleMap().getStyle(16);
            Element element = editorDocument.getDefaultRootElement();
            EditorDocument.StyledLeafElement styledLeafElement = (EditorDocument.StyledLeafElement)element.getElement(n2);
            int n4 = styledLeafElement.getStartOffset();
            int n5 = styledLeafElement.getEndOffset();
            n5 = Math.min(editorDocument.getLength(), n5);
            int n6 = this.calculateMaxCharsPerLine();
            LineMark[] lineMarkArray = editorDocument.getLineMarks(n2);
            for (n3 = 0; n3 < lineMarkArray.length; ++n3) {
                if (lineMarkArray[n3].getStyle() == style) {
                    object = graphics.getColor();
                    graphics.setColor(Color.yellow);
                    graphics.fillRect(this.getLineXPos(this.currentLineInPageCount), this.getLineYPos(this.currentLineInPageCount) - this.codeFontMetrics.getAscent(), this.a(this.getCodeFontMetrics()) * n6 + this.getLineNumberingWidth(), this.b(this.getCodeFontMetrics()));
                    graphics.setColor(Color.blue);
                    graphics.setFont(new Font(this.getCodeFontName(), 1, this.getCodeFontSize() + 2));
                    graphics.drawString("+", this.getLineXPos(this.currentLineInPageCount), this.getLineYPos(this.currentLineInPageCount));
                    graphics.setColor((Color)object);
                }
                if (lineMarkArray[n3].getStyle() != style2) continue;
                object = graphics.getColor();
                graphics.setColor(new Color(255, 200, 200));
                graphics.fillRect(this.getLineXPos(this.currentLineInPageCount), this.getLineYPos(this.currentLineInPageCount) - this.codeFontMetrics.getAscent(), this.a(this.getCodeFontMetrics()) * n6 + this.getLineNumberingWidth(), this.b(this.getCodeFontMetrics()));
                graphics.setColor(Color.red);
                graphics.setFont(new Font(this.getCodeFontName(), 1, this.getCodeFontSize() + 2));
                graphics.drawString("-", this.getLineXPos(this.currentLineInPageCount), this.getLineYPos(this.currentLineInPageCount));
                graphics.setColor((Color)object);
            }
            if (this.lineNumberingEnabled) {
                graphics.setFont(new Font(this.getCodeFontName(), 0, this.getCodeFontSize()));
                if (this.isColorEnabled()) {
                    graphics.setColor(this.getLineNumberColor());
                } else {
                    graphics.setColor(Color.black);
                }
                graphics.drawString(this.a(n2 + 1), this.getLineXPos(this.currentLineInPageCount), this.getLineYPos(this.currentLineInPageCount));
            }
            n3 = styledLeafElement.getText().length();
            object = this.deTabify(styledLeafElement.getText());
            int n7 = ((String)object).length() - n3;
            if (((String)object).length() > n6 && this.isLineWrapEnabled()) {
                Object object2 = object;
                int n8 = 1;
                int n9 = n4;
                while (((String)object2).length() > n6) {
                    int n10 = this.a((String)object2, n6);
                    this.drawLineOnPage(graphics, styledLeafElement, n9, n9 + n10 - n7);
                    n9 = n9 + n10 - n7;
                    if (n10 < ((String)object2).length() - 1 && this.isWrapAroundSymbolEnabled()) {
                        this.a(graphics, this.getLineXPos(this.currentLineInPageCount) + this.getLineNumberingWidth() + this.a(this.getCodeFontMetrics()) * (n6 - 1), this.getLineYPos(this.currentLineInPageCount - 1) + this.getCodeFontMetrics().getAscent());
                    }
                    object2 = ((String)object2).substring(n10);
                    ++n8;
                }
                this.drawLineOnPage(graphics, styledLeafElement, n9, n5);
                int n11 = n8;
                return n11;
            }
            this.drawLineOnPage(graphics, styledLeafElement, n4, n5);
            int n12 = 1;
            return n12;
        }
        catch (BadLocationException badLocationException) {
            int n13 = 0;
            return n13;
        }
    }

    public int print(Graphics graphics, PageFormat pageFormat, int n2) throws PrinterException {
        this.pageIndex = n2;
        ++this.callCounter;
        this.currentLineInPageCount = 0;
        if (n2 >= this.numPages || n2 < 0) {
            return 1;
        }
        Document document = this.editor.getDocument();
        Element element = document.getDefaultRootElement();
        int n3 = ((d)this.pageInfoVector.elementAt((int)n2)).a;
        int n4 = ((d)this.pageInfoVector.elementAt((int)n2)).b;
        if (this.isHeaderEnabled() && (!this.isHeaderOnFirstPageOnlyEnabled() || this.isFirstPage())) {
            this.drawHeader(graphics, pageFormat, n2);
        }
        for (int i2 = n3; i2 < n4; ++i2) {
            this.drawLineFromEditor(i2, graphics);
        }
        this.b(graphics, pageFormat, this.getSectionsPerPage());
        if (this.isSectionNumberingEnabled()) {
            this.a(graphics, n2 + 1);
        }
        if (this.isDrawBorderEnabled()) {
            this.drawBorder(graphics, pageFormat);
        }
        return 0;
    }

    public Printable getPrintable(int n2) throws IndexOutOfBoundsException {
        if (n2 >= this.numPages || n2 < 0) {
            throw new IndexOutOfBoundsException();
        }
        return this;
    }

    public PageFormat getPageFormat(int n2) throws IndexOutOfBoundsException {
        if (n2 >= this.numPages || n2 < 0) {
            throw new IndexOutOfBoundsException();
        }
        return pageFormat;
    }

    public int getNumberOfPages() {
        return this.numPages;
    }

    public void init() {
        this.c = EditorPrintSettings.unFormattedPageHeader.getValue();
        this.d = EditorPrintSettings.unFormattedDateHeader.getValue();
        this.b = EditorPrintSettings.unFormattedTitleHeader.getValue();
        this.showHeadersOnFirstPageOnly = EditorPrintSettings.showHeadersOnFirstPageOnly.getBoolean();
        this.useSmartWrapping = EditorPrintSettings.wrapSettings.getInteger() == 1;
        this.lineNumberingEnabled = EditorPrintSettings.lineNumberingEnabled.getBoolean();
        this.sectionNumberingEnabled = EditorPrintSettings.sectionNumberingEnabled.getBoolean();
        this.lineWrapEnabled = EditorPrintSettings.wrapSettings.getInteger() != 0;
        this.headerEnabled = EditorPrintSettings.headerEnabled.getBoolean();
        this.colorEnabled = EditorPrintSettings.colorEnabled.getBoolean();
        this.syntaxPrintEnabled = EditorPrintSettings.syntaxPrintEnabled.getBoolean();
        this.headerFontName = EditorPrintSettings.headerFontName.getValue();
        this.headerShading = EditorPrintSettings.showHeadersInShadedBox.getBoolean();
        this.headerFontSize = EditorPrintSettings.headerFontSize.getInteger();
        this.codeFontSize = EditorPrintSettings.codeFontSize.getInteger();
        this.lineNumberingInterval = EditorPrintSettings.lineNumberingInterval.getInteger();
        this.codeFontName = EditorPrintSettings.codeFontFace.getValue();
        this.drawBorderEnabled = EditorPrintSettings.drawBorderEnabled.getBoolean();
        this.updateHeaderFontMetrics();
        this.updateCodeFontMetrics();
    }

    public EditorPagePrinter(EditorPane editorPane, PageFormat pageFormat) {
        this.headerShadingColor = new Color(223, 223, 223);
        this.j = Color.white;
        this.jobName = com.borland.primetime.printer.c.a(11);
        this.pageInfoVector = new Vector();
        this.lineNumberColor = Color.cyan;
        this.pagesPerSheet = EditorPrintSettings.sectionsPerPage.getInteger();
        this.editor = editorPane;
        EditorPagePrinter.pageFormat = pageFormat;
        this.filename = Browser.getActiveBrowser().getActiveNode().getLongDisplayName();
        this.init();
    }
}

