/*
 * Decompiled with CFR 0.152.
 */
package com.borland.sanctuary.lm.mgr;

import com.borland.sanctuary.lm.mgr.Info;
import com.borland.sanctuary.lm.mgr.ProductInfo;
import com.borland.sanctuary.lm.mgr.SlipException;
import com.borland.sanctuary.lm.util.Data;
import com.borland.sanctuary.srs.v5.common.Spacial;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class Slip
extends Info {
    public static final String ENVELOPE_MAXUSERS = "constraint.users";
    public static final String ENVELOPE_MAXINSTALLS = "constraint.maxinstalls";
    public static final String ENVELOPE_EXPORTABLE = "export.allowed";
    public static final String ENVELOPE_IMPORTABLE = "import.allowed";
    public static final String ENVELOPE_SILENTIMPORT = "import.silent";
    public static final String ENVELOPE_NODELOCK = "nodelock.physical";
    public static final String ENVELOPE_SESSIONLOCK = "nodelock.session";
    public static final String ENVELOPE_LICENSEDSERIAL = "licensed.serialno";
    public static final String ENVELOPE_LICENSEDCOMPANY = "licensed.company";
    public static final String ENVELOPE_LICENSEDPERSON = "licensed.person";
    protected static final int ENCODING_SEED = -403099198;
    protected byte[] rawData;
    protected Hashtable productInfoHash;

    static {
        ENCODING_SEED = -403099198;
        ENVELOPE_LICENSEDPERSON = ENVELOPE_LICENSEDPERSON;
        ENVELOPE_LICENSEDCOMPANY = ENVELOPE_LICENSEDCOMPANY;
        ENVELOPE_LICENSEDSERIAL = ENVELOPE_LICENSEDSERIAL;
        ENVELOPE_SESSIONLOCK = ENVELOPE_SESSIONLOCK;
        ENVELOPE_NODELOCK = ENVELOPE_NODELOCK;
        ENVELOPE_SILENTIMPORT = ENVELOPE_SILENTIMPORT;
        ENVELOPE_IMPORTABLE = ENVELOPE_IMPORTABLE;
        ENVELOPE_EXPORTABLE = ENVELOPE_EXPORTABLE;
        ENVELOPE_MAXINSTALLS = ENVELOPE_MAXINSTALLS;
        ENVELOPE_MAXUSERS = ENVELOPE_MAXUSERS;
    }

    public String toString() {
        return null;
    }

    public InputStream toStream() throws IOException {
        if (this.isExportable()) {
            return new ByteArrayInputStream(this.rawData);
        }
        return null;
    }

    public ProductInfo getProductLicenseById(int n2) {
        ProductInfo productInfo = (ProductInfo)this.productInfoHash.get(new Integer(n2));
        return productInfo;
    }

    public ProductInfo[] getProductLicenses() {
        Vector vector = new Vector();
        Enumeration enumeration = this.productInfoHash.elements();
        while (enumeration.hasMoreElements()) {
            vector.add(enumeration.nextElement());
        }
        Object[] objectArray = new ProductInfo[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public boolean isSilentImport() {
        return this.a(ENVELOPE_SILENTIMPORT) > 0;
    }

    public boolean isExportable() {
        ProductInfo[] productInfoArray;
        boolean bl;
        boolean bl2 = bl = this.a(ENVELOPE_EXPORTABLE) > 0;
        if (bl && (productInfoArray = this.getProductLicenses()) != null) {
            for (int i2 = 0; i2 < productInfoArray.length; ++i2) {
                bl &= productInfoArray[i2].j();
            }
        }
        return bl;
    }

    public boolean isImportable() {
        return this.a(ENVELOPE_IMPORTABLE) > 0;
    }

    public boolean isNodeLocked() {
        long l2 = this.getNodeLock();
        return l2 != (long)0 && l2 != (long)-1;
    }

    public long getNodeLock() {
        return this.a(ENVELOPE_NODELOCK);
    }

    public boolean isSessionLocked() {
        long l2 = this.getSessionLock();
        return l2 != (long)0 && l2 != (long)-1;
    }

    public long getSessionLock() {
        return this.a(ENVELOPE_SESSIONLOCK);
    }

    String a() {
        return this.getValue(ENVELOPE_LICENSEDSERIAL);
    }

    public String getLicensedCompany() {
        return this.getValue(ENVELOPE_LICENSEDCOMPANY);
    }

    public String getLicensedPerson() {
        return this.getValue(ENVELOPE_LICENSEDPERSON);
    }

    private int a(String string) {
        String string2 = this.getValue(string);
        try {
            int n2 = new Integer(string2);
            return n2;
        }
        catch (NumberFormatException numberFormatException) {
            int n3 = -1;
            return n3;
        }
    }

    public String getEnvelopeValue(String string) {
        return this.getValue(string);
    }

    public Enumeration getEnvelopeProperties() {
        return this.values.keys();
    }

    private static int a(byte[] byArray) {
        int n2 = -403099198;
        int n3 = 0;
        while (n3 < byArray.length) {
            byte by = byArray[n3];
            int n4 = n3++;
            byArray[n4] = (byte)(byArray[n4] ^ (byte)(n2 >> 24 & 0xFF));
            n2 ^= by;
            n2 ^= n2 << 8;
            n2 ^= n2 << 16;
            n2 ^= n2 << 24;
        }
        return n2;
    }

    private ProductInfo a(BufferedReader bufferedReader) throws IOException {
        Hashtable hashtable = new Hashtable();
        Hashtable hashtable2 = new Hashtable();
        this.a(bufferedReader, hashtable);
        this.a(bufferedReader, hashtable2);
        ProductInfo productInfo = new ProductInfo(hashtable, hashtable2);
        return productInfo;
    }

    private void a(BufferedReader bufferedReader, Hashtable hashtable) throws IOException {
        int n2 = Integer.parseInt(bufferedReader.readLine());
        for (int i2 = 0; i2 < n2; ++i2) {
            String string = bufferedReader.readLine();
            String string2 = bufferedReader.readLine();
            hashtable.put(string, string2);
        }
    }

    private void b(InputStream inputStream) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        try {
            Hashtable hashtable = new Hashtable();
            Hashtable<Integer, ProductInfo> hashtable2 = new Hashtable<Integer, ProductInfo>();
            this.a(bufferedReader, hashtable);
            int n2 = Integer.parseInt(bufferedReader.readLine());
            for (int i2 = 0; i2 < n2; ++i2) {
                ProductInfo productInfo = this.a(bufferedReader);
                hashtable2.put(new Integer(productInfo.getProductId()), productInfo);
            }
            this.values = hashtable;
            this.productInfoHash = hashtable2;
        }
        catch (Exception exception) {
            throw new IOException(Data.CORRUPTED_FILE);
        }
    }

    private void a(InputStream inputStream) throws IOException {
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        this.rawData = null;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        int n2 = dataInputStream.readInt();
        int n3 = dataInputStream.readInt();
        dataOutputStream.writeInt(n2);
        dataOutputStream.writeInt(n3);
        if (n3 > 1000000) {
            throw new IOException(Data.CORRUPTED_FILE);
        }
        byte[] byArray = new byte[n3];
        dataInputStream.readFully(byArray);
        dataInputStream.close();
        dataOutputStream.write(byArray);
        dataOutputStream.close();
        if (Slip.a(byArray) != n2) {
            throw new IOException(Data.CORRUPTED_FILE);
        }
        this.b(new ByteArrayInputStream(byArray));
        this.rawData = byteArrayOutputStream.toByteArray();
    }

    public void setReferences(Slip slip) {
        this.productInfoHash = slip.productInfoHash;
        this.rawData = slip.rawData;
        this.values = slip.values;
    }

    public Slip(String string) throws IOException, SlipException {
        try {
            string = Spacial.newURLDecode(string);
            byte[] byArray = new byte[string.length()];
            for (int i2 = 0; i2 < string.length(); ++i2) {
                byArray[i2] = (byte)string.charAt(i2);
            }
            this.productInfoHash = new Hashtable();
            this.rawData = null;
            this.a(new ByteArrayInputStream(byArray));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new SlipException(SlipException.CORRUPTED_LICENSE);
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            throw new SlipException(SlipException.CORRUPTED_LICENSE);
        }
    }

    public Slip(InputStream inputStream) throws IOException {
        this.productInfoHash = new Hashtable();
        this.rawData = null;
        this.a(inputStream);
    }

    public Slip() {
        this.productInfoHash = new Hashtable();
        this.rawData = null;
    }
}

