/*
 * Decompiled with CFR 0.152.
 */
package com.jformdesigner.model;

import com.jformdesigner.model.FormBinding;
import com.jformdesigner.model.FormBindingVisitor;
import com.jformdesigner.model.FormModelEventProvider;
import com.jformdesigner.model.FormObject;
import com.jformdesigner.model.FormRoot;
import com.jformdesigner.model.FormSelectable;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FormBindingGroup
extends FormObject
implements FormSelectable {
    public static final String PROP_NAME = "name";
    public static final String PROP_BOUND = "bound";
    private static final FormBinding[] EMPTY_BINDINGS = new FormBinding[0];
    private final Class<?> bindingGroupClass;
    private final ArrayList<FormBinding> bindings = new ArrayList();
    private FormRoot root;

    public FormBindingGroup(Class<?> bindingGroupClass) {
        this.bindingGroupClass = bindingGroupClass;
    }

    FormBindingGroup(FormBindingGroup obj) {
        super(obj, 0);
        this.bindingGroupClass = obj.bindingGroupClass;
        int bindingCount = obj.getBindingCount();
        for (int i = 0; i < bindingCount; ++i) {
            this.addBinding(new FormBinding(obj.getBinding(i)));
        }
    }

    public Object clone() {
        return new FormBindingGroup(this);
    }

    public Class<?> getBindingGroupClass() {
        return this.bindingGroupClass;
    }

    public String getName() {
        String name = this.getPropertyString(PROP_NAME);
        if (name == null) {
            name = "bindingGroup";
        }
        return name;
    }

    public int getBindingCount() {
        return this.bindings.size();
    }

    public FormBinding getBinding(int index) {
        return this.bindings.get(index);
    }

    public FormBinding[] getBindings() {
        return !this.bindings.isEmpty() ? this.bindings.toArray(new FormBinding[this.bindings.size()]) : EMPTY_BINDINGS;
    }

    public int getBindingIndex(FormBinding binding) {
        return this.bindings.indexOf(binding);
    }

    public void addBinding(FormBinding binding) {
        this.addBinding(binding, -1);
    }

    public void addBinding(FormBinding binding, int index) {
        if (index < 0 || index == this.bindings.size()) {
            index = this.bindings.size();
            this.bindings.add(binding);
        } else {
            this.bindings.add(index, binding);
        }
        binding.setBindingGroup(this);
        FormModelEventProvider eventProvider = this.getEventProvider();
        if (eventProvider != null) {
            eventProvider.fireBindingAdded(this, binding, index);
        }
    }

    public void removeBinding(FormBinding binding) {
        int index = this.bindings.indexOf(binding);
        if (index >= 0) {
            this.removeBinding(index);
        }
    }

    public void removeBinding(int index) {
        FormBinding binding = this.bindings.remove(index);
        binding.setBindingGroup(null);
        FormModelEventProvider eventProvider = this.getEventProvider();
        if (eventProvider != null) {
            eventProvider.fireBindingRemoved(this, binding, index);
        }
    }

    public FormRoot getRoot() {
        return this.root;
    }

    void setRoot(FormRoot root) {
        if (this.root != null && root != null) {
            throw new IllegalStateException("Already attached (current=\"" + this.root + "\", new=\"" + root + "\").");
        }
        this.root = root;
    }

    public boolean accept(FormBindingVisitor visitor) {
        int count = this.bindings.size();
        for (int i = 0; i < count; ++i) {
            if (this.bindings.get(i).accept(visitor)) continue;
            return false;
        }
        return true;
    }

    FormModelEventProvider getEventProvider() {
        return this.root != null && this.root.model != null && this.root.model.eventProvider != null ? this.root.model.eventProvider : null;
    }

    @Override
    void firePropertyChanged(String name, int index, Object oldValue, Object newValue) {
        FormModelEventProvider eventProvider = this.getEventProvider();
        if (eventProvider != null) {
            eventProvider.fireBindingGroupPropertyChanged(this, name, index, oldValue, newValue);
        }
    }

    @Override
    void updateReferences(String oldName, String newName) {
        super.updateReferences(oldName, newName);
        int count = this.bindings.size();
        for (int i = 0; i < count; ++i) {
            this.bindings.get(i).updateReferences(oldName, newName);
        }
    }

    @Override
    public String toString() {
        return FormBindingGroup.unqualifiedClassName(this.getClass()) + "[bindingGroupClass=" + this.bindingGroupClass + "] " + super.toString();
    }
}

