/*
 * Decompiled with CFR 0.152.
 */
package com.jformdesigner.model;

import com.jformdesigner.model.FormObject;
import com.jformdesigner.model.SwingResource;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;
import java.beans.Beans;
import java.net.URL;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.UIManager;

public class SwingIcon
implements Icon,
SwingResource {
    public static final int CLASSPATH = 0;
    public static final int FILE = 1;
    public static final int SWING = 2;
    private final int type;
    private final String name;

    public SwingIcon(int type, String name) {
        this.type = type;
        this.name = name;
    }

    public int getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public Icon createIcon(ClassLoader loader) {
        if (this.type == 0) {
            String resName = this.name.startsWith("/") ? this.name.substring(1) : this.name;
            URL url = loader.getResource(resName);
            if (url != null) {
                return SwingIcon.loadIcon(url);
            }
        } else {
            if (this.type == 1) {
                return SwingIcon.loadIcon(this.name);
            }
            if (this.type == 2) {
                return UIManager.getIcon(this.name);
            }
        }
        return null;
    }

    private static ImageIcon loadIcon(URL url) {
        if (Beans.isDesignTime()) {
            Image image = Toolkit.getDefaultToolkit().createImage(url);
            return image != null ? new ImageIcon(image, url.toExternalForm()) : new ImageIcon();
        }
        return new ImageIcon(url);
    }

    private static ImageIcon loadIcon(String filename) {
        if (Beans.isDesignTime()) {
            Image image = Toolkit.getDefaultToolkit().createImage(filename);
            return image != null ? new ImageIcon(image, filename) : new ImageIcon();
        }
        return new ImageIcon(filename);
    }

    public int getIconWidth() {
        return 1;
    }

    public int getIconHeight() {
        return 1;
    }

    public void paintIcon(Component c, Graphics g, int x, int y) {
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SwingIcon)) {
            return false;
        }
        return this.type == ((SwingIcon)obj).type && this.name.equals(((SwingIcon)obj).name);
    }

    public int hashCode() {
        return this.type + this.name.hashCode();
    }

    public String toString() {
        return FormObject.unqualifiedClassName(this.getClass()) + "[type=" + this.type + ",name=" + this.name + "]";
    }
}

