/*
 * Decompiled with CFR 0.152.
 */
package com.jformdesigner.runtime;

import com.jformdesigner.model.FormLayoutManager;
import com.jformdesigner.runtime.AbstractLayoutCreator;
import com.jformdesigner.runtime.FormSpecCoder;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import java.awt.Container;
import java.awt.LayoutManager;

class FormLayoutCreator
extends AbstractLayoutCreator {
    private static final String PROP_COLUMN_SPECS = "$columnSpecs";
    private static final String PROP_ROW_SPECS = "$rowSpecs";
    private static final String PROP_COLUMN_GROUP_IDS = "$columnGroupIds";
    private static final String PROP_ROW_GROUP_IDS = "$rowGroupIds";

    FormLayoutCreator() {
    }

    public LayoutManager createLayoutManager(Container container, FormLayoutManager formLayout) throws InstantiationException, IllegalAccessException {
        String encodedColumnSpecs = formLayout.getPropertyString(PROP_COLUMN_SPECS, "");
        String encodedRowSpecs = formLayout.getPropertyString(PROP_ROW_SPECS, "");
        String encodedColumnGroupIds = formLayout.getPropertyString(PROP_COLUMN_GROUP_IDS, null);
        String encodedRowGroupIds = formLayout.getPropertyString(PROP_ROW_GROUP_IDS, null);
        ColumnSpec[] columnSpecs = FormSpecCoder.decodeColumnSpecs(encodedColumnSpecs);
        RowSpec[] rowSpecs = FormSpecCoder.decodeRowSpecs(encodedRowSpecs);
        int[][] columnGroups = FormSpecCoder.decodeGroupIndices(encodedColumnGroupIds);
        int[][] rowGroups = FormSpecCoder.decodeGroupIndices(encodedRowGroupIds);
        FormLayout layout = new FormLayout(columnSpecs, rowSpecs);
        if (columnGroups != null) {
            layout.setColumnGroups(columnGroups);
        }
        if (rowGroups != null) {
            layout.setRowGroups(rowGroups);
        }
        return layout;
    }
}

