/*
 * Decompiled with CFR 0.152.
 */
package com.jformdesigner.model;

import com.jformdesigner.model.FormBindingGroup;
import com.jformdesigner.model.FormBindingVisitor;
import com.jformdesigner.model.FormModelEventProvider;
import com.jformdesigner.model.FormObject;
import com.jformdesigner.model.FormReference;
import java.util.Map;

public class FormBinding
extends FormObject {
    public static final String PROP_SOURCE = "source";
    public static final String PROP_SOURCE_PATH = "sourcePath";
    public static final String PROP_TARGET = "target";
    public static final String PROP_TARGET_PATH = "targetPath";
    private FormBindingGroup bindingGroup;

    public FormBinding() {
    }

    public FormBinding(String string, String string2, String string3, String string4) {
        this.setProperty(PROP_SOURCE, string);
        this.setProperty(PROP_SOURCE_PATH, string2);
        this.setProperty(PROP_TARGET, string3);
        this.setProperty(PROP_TARGET_PATH, string4);
    }

    FormBinding(FormBinding formBinding) {
        super(formBinding, 0);
    }

    public Object clone() {
        return new FormBinding(this);
    }

    public String getSource() {
        return this.getPropertyString(PROP_SOURCE);
    }

    public String getSourcePath() {
        return this.getPropertyString(PROP_SOURCE_PATH);
    }

    public String getTarget() {
        return this.getPropertyString(PROP_TARGET);
    }

    public String getTargetPath() {
        return this.getPropertyString(PROP_TARGET_PATH);
    }

    public FormBindingGroup getBindingGroup() {
        return this.bindingGroup;
    }

    void setBindingGroup(FormBindingGroup formBindingGroup) {
        if (this.bindingGroup != null && formBindingGroup != null) {
            throw new IllegalStateException("Already attached (current=\"" + this.bindingGroup + "\", new=\"" + formBindingGroup + "\").");
        }
        this.bindingGroup = formBindingGroup;
    }

    public boolean accept(FormBindingVisitor formBindingVisitor) {
        return formBindingVisitor.visit(this);
    }

    private FormModelEventProvider getEventProvider() {
        return this.bindingGroup != null ? this.bindingGroup.getEventProvider() : null;
    }

    void firePropertyChanged(String string, int n2, Object object, Object object2) {
        FormModelEventProvider formModelEventProvider = this.getEventProvider();
        if (formModelEventProvider != null) {
            formModelEventProvider.fireBindingPropertyChanged(this, string, n2, object, object2);
        }
    }

    void updateReferences(String string, String string2) {
        super.updateReferences(string, string2);
        if (string.equals(this.getSource())) {
            this.setProperty(PROP_SOURCE, string2);
        }
        if (string.equals(this.getTarget())) {
            this.setProperty(PROP_TARGET, string2);
        }
        for (Map.Entry<String, Object> entry : this.properties()) {
            Object object = entry.getValue();
            if (!(object instanceof FormBinding[])) continue;
            this.updateReferencesInSubBindings(entry.getKey(), (FormBinding[])object, string, string2);
        }
    }

    private void updateReferencesInSubBindings(String string, FormBinding[] formBindingArray, String string2, String string3) {
        FormBinding[] formBindingArray2 = null;
        block0: for (int i2 = 0; i2 < formBindingArray.length; ++i2) {
            FormBinding formBinding = formBindingArray[i2];
            int n2 = formBinding.getReferenceCount();
            if (n2 == 0) continue;
            for (Map.Entry<String, Object> entry : formBinding.properties()) {
                Object object = entry.getValue();
                if (!(object instanceof FormReference)) continue;
                if (string2.equals(((FormReference)object).getName())) {
                    if (formBindingArray2 == null) {
                        formBindingArray2 = FormBinding.clone(formBindingArray);
                    }
                    formBindingArray2[i2].setProperty(entry.getKey(), string3 != null ? new FormReference(string3) : null);
                }
                if (--n2 > 0) continue;
                continue block0;
            }
        }
        if (formBindingArray2 != null) {
            this.setProperty(string, formBindingArray2);
        }
    }

    public static FormBinding[] clone(FormBinding[] formBindingArray) {
        FormBinding[] formBindingArray2 = new FormBinding[formBindingArray.length];
        for (int i2 = 0; i2 < formBindingArray.length; ++i2) {
            formBindingArray2[i2] = (FormBinding)formBindingArray[i2].clone();
        }
        return formBindingArray2;
    }

    public String toString() {
        return FormBinding.unqualifiedClassName(this.getClass()) + " " + super.toString();
    }
}

