/*
 * Decompiled with CFR 0.152.
 */
package com.jformdesigner.model;

import com.jformdesigner.model.FormComponent;
import com.jformdesigner.model.FormModel;
import com.jformdesigner.model.FormObject;

public class FormEvent {
    public static final String FIELD_HANDLER = "handler";
    public static final String FIELD_PASS_PARAMS = "passParams";
    public static final String FIELD_PROPERTY_NAME = "propertyName";
    static final FormEvent[] EMPTY_EVENTS = new FormEvent[0];
    private final String listener;
    private final String listenerMethod;
    private String handler;
    private boolean passParams;
    private String propertyName;
    private FormComponent component;

    public FormEvent(String string, String string2, String string3, boolean bl2) {
        this(string, string2, string3, bl2, null);
    }

    public FormEvent(String string, String string2, String string3, boolean bl2, String string4) {
        this.listener = string;
        this.listenerMethod = string2;
        this.handler = string3;
        this.passParams = bl2;
        this.propertyName = string4;
    }

    public FormEvent(FormEvent formEvent) {
        this.listener = formEvent.listener;
        this.listenerMethod = formEvent.listenerMethod;
        this.handler = formEvent.handler;
        this.passParams = formEvent.passParams;
        this.propertyName = formEvent.propertyName;
    }

    public String getListener() {
        return this.listener;
    }

    public String getListenerMethod() {
        return this.listenerMethod;
    }

    public String getHandler() {
        return this.handler;
    }

    public void setHandler(String string) {
        if (FormObject.safeEquals(this.handler, string)) {
            return;
        }
        String string2 = this.handler;
        this.handler = string;
        this.fireFieldChanged(FIELD_HANDLER, string2, string);
    }

    public boolean getPassParams() {
        return this.passParams;
    }

    public void setPassParams(boolean bl2) {
        if (this.passParams == bl2) {
            return;
        }
        boolean bl3 = this.passParams;
        this.passParams = bl2;
        this.fireFieldChanged(FIELD_PASS_PARAMS, bl3, bl2);
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public void setPropertyName(String string) {
        if (FormObject.safeEquals(this.propertyName, string)) {
            return;
        }
        String string2 = this.propertyName;
        this.propertyName = string;
        this.fireFieldChanged(FIELD_PROPERTY_NAME, string2, string);
    }

    public FormComponent getComponent() {
        return this.component;
    }

    void setComponent(FormComponent formComponent) {
        if (this.component != null && formComponent != null) {
            throw new IllegalStateException("Already attached (current=\"" + this.component + "\", new=\"" + formComponent + "\").");
        }
        this.component = formComponent;
    }

    private void fireFieldChanged(String string, Object object, Object object2) {
        FormModel formModel;
        FormModel formModel2 = formModel = this.component != null ? this.component.getModel() : null;
        if (formModel != null && formModel.eventProvider != null) {
            formModel.eventProvider.fireEventFieldChanged(this, string, object, object2);
        }
    }

    public String toString() {
        return FormObject.unqualifiedClassName(this.getClass()) + "[listener=" + this.listener + ",listenerMethod=" + this.listenerMethod + ",handler=" + this.handler + ",passParams=" + this.passParams + "] " + super.toString();
    }
}

