/*
 * Decompiled with CFR 0.152.
 */
package com.jformdesigner.model;

import com.jformdesigner.model.FormBindingGroup;
import com.jformdesigner.model.FormBindingVisitor;
import com.jformdesigner.model.FormContainer;
import com.jformdesigner.model.FormLayoutManager;
import java.util.ArrayList;

public class FormRoot
extends FormContainer {
    private static final FormBindingGroup[] EMPTY_BINDING_GROUPS = new FormBindingGroup[0];
    private ArrayList<FormBindingGroup> bindingGroups;

    public FormRoot() {
        super((String)null, new FormLayoutManager(null));
    }

    FormRoot(FormRoot formRoot, int n2) {
        super(formRoot, n2);
    }

    public Object clone() {
        return new FormRoot(this, 0);
    }

    public int getBindingGroupCount() {
        return this.bindingGroups != null ? this.bindingGroups.size() : 0;
    }

    public FormBindingGroup getBindingGroup(int n2) {
        return this.bindingGroups.get(n2);
    }

    public FormBindingGroup getBindingGroup(String string) {
        if (this.bindingGroups == null) {
            return null;
        }
        for (FormBindingGroup formBindingGroup : this.bindingGroups) {
            if (!string.equals(formBindingGroup.getName())) continue;
            return formBindingGroup;
        }
        return null;
    }

    public FormBindingGroup[] getBindingGroups() {
        return this.bindingGroups != null ? this.bindingGroups.toArray(new FormBindingGroup[this.bindingGroups.size()]) : EMPTY_BINDING_GROUPS;
    }

    public int getBindingGroupIndex(FormBindingGroup formBindingGroup) {
        return this.bindingGroups.indexOf(formBindingGroup);
    }

    public void addBindingGroup(FormBindingGroup formBindingGroup) {
        this.addBindingGroup(formBindingGroup, -1);
    }

    public void addBindingGroup(FormBindingGroup formBindingGroup, int n2) {
        if (this.bindingGroups == null) {
            this.bindingGroups = new ArrayList();
        }
        if (n2 < 0 || n2 == this.bindingGroups.size()) {
            n2 = this.bindingGroups.size();
            this.bindingGroups.add(formBindingGroup);
        } else {
            this.bindingGroups.add(n2, formBindingGroup);
        }
        formBindingGroup.setRoot(this);
        if (this.model != null && this.model.eventProvider != null) {
            this.model.eventProvider.fireBindingGroupAdded(this, formBindingGroup, n2);
        }
    }

    public void removeBindingGroup(FormBindingGroup formBindingGroup) {
        if (this.bindingGroups == null) {
            return;
        }
        int n2 = this.bindingGroups.indexOf(formBindingGroup);
        if (n2 >= 0) {
            this.removeBindingGroup(n2);
        }
    }

    public void removeBindingGroup(int n2) {
        if (this.bindingGroups == null) {
            return;
        }
        FormBindingGroup formBindingGroup = this.bindingGroups.remove(n2);
        formBindingGroup.setRoot(null);
        if (this.model != null && this.model.eventProvider != null) {
            this.model.eventProvider.fireBindingGroupRemoved(this, formBindingGroup, n2);
        }
    }

    public boolean accept(FormBindingVisitor formBindingVisitor) {
        if (this.bindingGroups == null) {
            return true;
        }
        int n2 = this.bindingGroups.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (this.bindingGroups.get(i2).accept(formBindingVisitor)) continue;
            return false;
        }
        return true;
    }

    void updateReferences(String string, String string2) {
        super.updateReferences(string, string2);
        if (this.bindingGroups != null) {
            int n2 = this.bindingGroups.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                this.bindingGroups.get(i2).updateReferences(string, string2);
            }
        }
    }
}

