/*
 * Decompiled with CFR 0.152.
 */
package com.jformdesigner.model;

import com.jformdesigner.model.FormObject;
import com.jformdesigner.model.SwingResource;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;
import java.beans.Beans;
import java.net.URL;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.UIManager;

public class SwingIcon
implements SwingResource,
Icon {
    public static final int CLASSPATH = 0;
    public static final int FILE = 1;
    public static final int SWING = 2;
    private final int type;
    private final String name;

    public SwingIcon(int n2, String string) {
        this.type = n2;
        this.name = string;
    }

    public int getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public Icon createIcon(ClassLoader classLoader) {
        if (this.type == 0) {
            String string = this.name.startsWith("/") ? this.name.substring(1) : this.name;
            URL uRL = classLoader.getResource(string);
            if (uRL != null) {
                return SwingIcon.loadIcon(uRL);
            }
        } else {
            if (this.type == 1) {
                return SwingIcon.loadIcon(this.name);
            }
            if (this.type == 2) {
                return UIManager.getIcon(this.name);
            }
        }
        return null;
    }

    private static ImageIcon loadIcon(URL uRL) {
        if (Beans.isDesignTime()) {
            Image image = Toolkit.getDefaultToolkit().createImage(uRL);
            return image != null ? new ImageIcon(image, uRL.toExternalForm()) : new ImageIcon();
        }
        return new ImageIcon(uRL);
    }

    private static ImageIcon loadIcon(String string) {
        if (Beans.isDesignTime()) {
            Image image = Toolkit.getDefaultToolkit().createImage(string);
            return image != null ? new ImageIcon(image, string) : new ImageIcon();
        }
        return new ImageIcon(string);
    }

    public int getIconWidth() {
        return 1;
    }

    public int getIconHeight() {
        return 1;
    }

    public void paintIcon(Component component, Graphics graphics, int n2, int n3) {
    }

    public boolean equals(Object object) {
        if (!(object instanceof SwingIcon)) {
            return false;
        }
        return this.type == ((SwingIcon)object).type && this.name.equals(((SwingIcon)object).name);
    }

    public int hashCode() {
        return this.type + this.name.hashCode();
    }

    public String toString() {
        return FormObject.unqualifiedClassName(this.getClass()) + "[type=" + this.type + ",name=" + this.name + "]";
    }
}

