/*
 * Decompiled with CFR 0.152.
 */
package com.jformdesigner.runtime;

import com.jformdesigner.model.FormModel;
import com.jformdesigner.runtime.FormSaver$1;
import com.jformdesigner.runtime.FormSaver$FileHeaderOutputStream;
import com.jformdesigner.runtime.FormSaver$FixCharOutputStream;
import com.jformdesigner.runtime.FormXMLPersistence;
import com.jformdesigner.runtime.MultiException;
import com.jformdesigner.runtime.XMLExceptionListener;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;

public class FormSaver {
    private FormSaver() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void save(FormModel formModel, OutputStream outputStream) {
        if (!(outputStream instanceof ByteArrayOutputStream) && !(outputStream instanceof BufferedOutputStream)) {
            outputStream = new BufferedOutputStream(outputStream);
        }
        if ("IBM J9 VM".equals(System.getProperty("java.vm.name"))) {
            outputStream = new FormSaver$FixCharOutputStream(outputStream);
        }
        if (formModel.fileHeader != null) {
            outputStream = new FormSaver$FileHeaderOutputStream(outputStream, formModel.fileHeader);
        }
        XMLExceptionListener xMLExceptionListener = new XMLExceptionListener();
        ClassLoader classLoader = formModel.getClassLoader();
        Thread thread = Thread.currentThread();
        ClassLoader classLoader2 = thread.getContextClassLoader();
        thread.setContextClassLoader(classLoader);
        try {
            FormXMLPersistence.initialize();
            try {
                FormXMLPersistence.initializePropertyPersistenceDelegates(formModel.getRoot(), classLoader);
            }
            catch (Throwable throwable) {
                Exception exception = throwable instanceof Exception ? (Exception)throwable : new InvocationTargetException(throwable);
                throw new MultiException("Failed to initialize property persistence delegates for encoding.", new Exception[]{exception});
            }
            FormSaver$1 formSaver$1 = new FormSaver$1(outputStream, classLoader);
            formSaver$1.setExceptionListener(xMLExceptionListener);
            formSaver$1.writeObject(formModel);
            formSaver$1.close();
        }
        finally {
            thread.setContextClassLoader(classLoader2);
            try {
                outputStream.close();
            }
            catch (IOException iOException) {}
        }
        if (xMLExceptionListener.getExceptionCount() > 0) {
            throw new MultiException("Failed to encode.", xMLExceptionListener.getExceptions());
        }
    }
}

