/*
 * Decompiled with CFR 0.152.
 */
package com.jformdesigner.runtime;

import com.jformdesigner.model.FormLayoutConstraints;
import com.jformdesigner.model.FormLayoutManager;
import com.jformdesigner.runtime.AbstractLayoutCreator;
import com.jformdesigner.runtime.GridBagConstraintsEx;
import com.jformdesigner.runtime.GridBagSpec;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;

public class GridBagLayoutCreator
extends AbstractLayoutCreator {
    private static final String PROP_COLUMN_SPECS = "$columnSpecs";
    private static final String PROP_ROW_SPECS = "$rowSpecs";
    private static final String PROP_HGAP = "$hGap";
    private static final String PROP_VGAP = "$vGap";
    private static final String PROP_ALIGN_LEFT = "$alignLeft";
    private static final String PROP_ALIGN_TOP = "$alignTop";
    private static final boolean DEF_ALIGN_LEFT = false;
    private static final boolean DEF_ALIGN_TOP = false;
    private GridBagSpec[] columnSpecs;
    private GridBagSpec[] rowSpecs;
    private int hGap;
    private int vGap;

    public LayoutManager createLayoutManager(Container container, FormLayoutManager formLayoutManager) {
        String string = formLayoutManager.getPropertyString(PROP_COLUMN_SPECS, "");
        String string2 = formLayoutManager.getPropertyString(PROP_ROW_SPECS, "");
        this.hGap = formLayoutManager.getPropertyInt(PROP_HGAP, 0);
        this.vGap = formLayoutManager.getPropertyInt(PROP_VGAP, 0);
        boolean bl2 = formLayoutManager.getPropertyBoolean(PROP_ALIGN_LEFT, false);
        boolean bl3 = formLayoutManager.getPropertyBoolean(PROP_ALIGN_TOP, false);
        this.columnSpecs = GridBagSpec.decodeSpecs(string);
        this.rowSpecs = GridBagSpec.decodeSpecs(string2);
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagLayout.columnWidths = GridBagLayoutCreator.computeMinSize(this.columnSpecs, this.hGap, bl2);
        gridBagLayout.rowHeights = GridBagLayoutCreator.computeMinSize(this.rowSpecs, this.vGap, bl3);
        gridBagLayout.columnWeights = GridBagLayoutCreator.computeWeights(this.columnSpecs, bl2);
        gridBagLayout.rowWeights = GridBagLayoutCreator.computeWeights(this.rowSpecs, bl3);
        return gridBagLayout;
    }

    public void addComponentToContainer(Container container, Component component, Object object, int n2, FormLayoutConstraints formLayoutConstraints) {
        object = GridBagLayoutCreator.updateConstraints(object, this.columnSpecs, this.rowSpecs, this.hGap, this.vGap);
        container.add(component, object, n2);
    }

    public static int[] computeMinSize(GridBagSpec[] gridBagSpecArray, int n2, boolean bl2) {
        int n3;
        if (!bl2) {
            boolean bl3 = true;
            for (n3 = 0; n3 < gridBagSpecArray.length; ++n3) {
                if (gridBagSpecArray[n3].getMinimumSize() == 0) continue;
                bl3 = false;
                break;
            }
            if (bl3) {
                return null;
            }
        }
        int[] nArray = new int[gridBagSpecArray.length + (bl2 ? 1 : 0)];
        for (n3 = 0; n3 < gridBagSpecArray.length; ++n3) {
            nArray[n3] = gridBagSpecArray[n3].getMinimumSize();
            if (n2 <= 0 || nArray[n3] <= 0 || n3 >= gridBagSpecArray.length - 1) continue;
            int n4 = n3;
            nArray[n4] = nArray[n4] + n2;
        }
        if (bl2) {
            nArray[gridBagSpecArray.length] = 0;
        }
        return nArray;
    }

    public static double[] computeWeights(GridBagSpec[] gridBagSpecArray, boolean bl2) {
        int n2;
        if (!bl2) {
            boolean bl3 = true;
            for (n2 = 0; n2 < gridBagSpecArray.length; ++n2) {
                if (gridBagSpecArray[n2].getResizeWeight() == 0.0) continue;
                bl3 = false;
                break;
            }
            if (bl3) {
                return null;
            }
        }
        double[] dArray = new double[gridBagSpecArray.length + (bl2 ? 1 : 0)];
        for (n2 = 0; n2 < gridBagSpecArray.length; ++n2) {
            dArray[n2] = gridBagSpecArray[n2].getResizeWeight();
        }
        if (bl2) {
            dArray[gridBagSpecArray.length] = 1.0E-4;
        }
        return dArray;
    }

    public static Object updateConstraints(Object object, GridBagSpec[] gridBagSpecArray, GridBagSpec[] gridBagSpecArray2, int n2, int n3) {
        if (!(object instanceof GridBagConstraintsEx)) {
            return object;
        }
        GridBagConstraintsEx gridBagConstraintsEx = (GridBagConstraintsEx)object;
        int n4 = gridBagConstraintsEx.getHAlign();
        int n5 = gridBagConstraintsEx.getVAlign();
        if (n2 == 0 && n3 == 0 && n4 != -1 && n5 != -1) {
            return gridBagConstraintsEx;
        }
        gridBagConstraintsEx = (GridBagConstraintsEx)gridBagConstraintsEx.clone();
        if (n4 == -1 && gridBagConstraintsEx.gridwidth == 1 && gridBagConstraintsEx.gridx >= 0 && gridBagConstraintsEx.gridx < gridBagSpecArray.length) {
            gridBagConstraintsEx.setHAlign(gridBagSpecArray[gridBagConstraintsEx.gridx].getDefaultAlignment());
        }
        if (n5 == -1 && gridBagConstraintsEx.gridheight == 1 && gridBagConstraintsEx.gridy >= 0 && gridBagConstraintsEx.gridy < gridBagSpecArray2.length) {
            gridBagConstraintsEx.setVAlign(gridBagSpecArray2[gridBagConstraintsEx.gridy].getDefaultAlignment());
        }
        if (n2 != 0 && gridBagConstraintsEx.gridx + gridBagConstraintsEx.gridwidth < gridBagSpecArray.length) {
            gridBagConstraintsEx.insets.right += n2;
        }
        if (n3 != 0 && gridBagConstraintsEx.gridy + gridBagConstraintsEx.gridheight < gridBagSpecArray2.length) {
            gridBagConstraintsEx.insets.bottom += n3;
        }
        return gridBagConstraintsEx;
    }
}

