/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.looks.common;

import com.jgoodies.looks.LookSwitchUtils;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.JComponent;
import javax.swing.JSeparator;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicPopupMenuSeparatorUI;

public final class ExtBasicPopupMenuSeparatorUI
extends BasicPopupMenuSeparatorUI {
    private static final int SEPARATOR_HEIGHT = 2;
    private Insets insets;
    private static ComponentUI popupMenuSeparatorUI;

    public static ComponentUI createUI(JComponent jComponent) {
        if (popupMenuSeparatorUI == null) {
            popupMenuSeparatorUI = new ExtBasicPopupMenuSeparatorUI();
        }
        return popupMenuSeparatorUI;
    }

    protected void installDefaults(JSeparator jSeparator) {
        super.installDefaults(jSeparator);
        this.insets = UIManager.getInsets("PopupMenuSeparator.margin");
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        Dimension dimension = jComponent.getSize();
        int n2 = this.insets.top;
        int n3 = this.insets.left;
        int n4 = this.insets.right;
        graphics.setColor(LookSwitchUtils.getColor("MenuItem.background"));
        graphics.fillRect(0, 0, dimension.width, dimension.height);
        graphics.translate(0, n2);
        graphics.setColor(jComponent.getForeground());
        graphics.drawLine(n3, 0, dimension.width - n4, 0);
        graphics.setColor(jComponent.getBackground());
        graphics.drawLine(n3, 1, dimension.width - n4, 1);
        graphics.translate(0, -n2);
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        return new Dimension(0, this.insets.top + 2 + this.insets.bottom);
    }
}

