/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.looks.plastic;

import com.jgoodies.looks.Options;
import com.jgoodies.looks.plastic.PlasticFieldCaret$1;
import java.awt.EventQueue;
import java.awt.event.FocusEvent;
import java.awt.event.MouseEvent;
import javax.swing.JFormattedTextField;
import javax.swing.SwingUtilities;
import javax.swing.plaf.UIResource;
import javax.swing.text.DefaultCaret;
import javax.swing.text.JTextComponent;

final class PlasticFieldCaret
extends DefaultCaret
implements UIResource {
    private boolean isKeyboardFocusEvent = true;

    PlasticFieldCaret() {
    }

    public void focusGained(FocusEvent focusEvent) {
        JTextComponent jTextComponent = this.getComponent();
        if (jTextComponent.isEnabled()) {
            this.setVisible(true);
            this.setSelectionVisible(true);
        }
        if (!(jTextComponent.isEnabled() && this.isKeyboardFocusEvent && Options.isSelectOnFocusGainActive(jTextComponent))) {
            return;
        }
        if (jTextComponent instanceof JFormattedTextField) {
            EventQueue.invokeLater(new PlasticFieldCaret$1(this));
        } else {
            this.selectAll();
        }
    }

    private void selectAll() {
        JTextComponent jTextComponent = this.getComponent();
        boolean bl2 = Boolean.TRUE.equals(jTextComponent.getClientProperty("JGoodies.invertSelection"));
        if (bl2) {
            this.setDot(jTextComponent.getDocument().getLength());
            this.moveDot(0);
        } else {
            this.setDot(0);
            this.moveDot(jTextComponent.getDocument().getLength());
        }
    }

    public void focusLost(FocusEvent focusEvent) {
        super.focusLost(focusEvent);
        if (!focusEvent.isTemporary()) {
            this.isKeyboardFocusEvent = true;
            if (Boolean.TRUE.equals(this.getComponent().getClientProperty("JGoodies.setCaretToStartOnFocusLost"))) {
                this.setDot(0);
            }
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (SwingUtilities.isLeftMouseButton(mouseEvent) || mouseEvent.isPopupTrigger()) {
            this.isKeyboardFocusEvent = false;
        }
        super.mousePressed(mouseEvent);
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        super.mouseReleased(mouseEvent);
        if (mouseEvent.isPopupTrigger()) {
            this.isKeyboardFocusEvent = false;
            if (this.getComponent() != null && this.getComponent().isEnabled() && this.getComponent().isRequestFocusEnabled()) {
                this.getComponent().requestFocus();
            }
        }
    }

    static /* synthetic */ void access$000(PlasticFieldCaret plasticFieldCaret) {
        plasticFieldCaret.selectAll();
    }
}

