/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.looks.plastic;

import com.jgoodies.looks.LookUtils;
import com.jgoodies.looks.Options;
import com.jgoodies.looks.plastic.PlasticTabbedPaneUI$AbstractRenderer;
import com.jgoodies.looks.plastic.PlasticTabbedPaneUI$MyPropertyChangeHandler;
import com.jgoodies.looks.plastic.PlasticTabbedPaneUI$ScrollTabsBackwardAction;
import com.jgoodies.looks.plastic.PlasticTabbedPaneUI$ScrollTabsForwardAction;
import com.jgoodies.looks.plastic.PlasticTabbedPaneUI$ScrollableTabSupport;
import com.jgoodies.looks.plastic.PlasticTabbedPaneUI$TabSelectionHandler;
import com.jgoodies.looks.plastic.PlasticTabbedPaneUI$TabbedPaneLayout;
import com.jgoodies.looks.plastic.PlasticTabbedPaneUI$TabbedPaneScrollLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.beans.PropertyChangeListener;
import javax.swing.ActionMap;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.metal.MetalTabbedPaneUI;
import javax.swing.text.View;

public final class PlasticTabbedPaneUI
extends MetalTabbedPaneUI {
    private static boolean isTabIconsEnabled = Options.isTabIconsEnabled();
    private Boolean noContentBorder;
    private Boolean embeddedTabs;
    private PlasticTabbedPaneUI$AbstractRenderer renderer;
    private Color selectHighlight;
    private PlasticTabbedPaneUI$ScrollableTabSupport tabScroller;
    private final int[] xCropLen = new int[]{1, 1, 0, 0, 1, 1, 2, 2};
    private final int[] yCropLen = new int[]{0, 3, 3, 6, 6, 9, 9, 12};
    private static final int CROP_SEGMENT = 12;

    public static ComponentUI createUI(JComponent jComponent) {
        return new PlasticTabbedPaneUI();
    }

    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        this.embeddedTabs = (Boolean)jComponent.getClientProperty("jgoodies.embeddedTabs");
        this.noContentBorder = (Boolean)jComponent.getClientProperty("jgoodies.noContentBorder");
        this.selectHighlight = UIManager.getColor("TabbedPane.selectHighlight");
        this.renderer = this.createRenderer(this.tabPane);
    }

    public void uninstallUI(JComponent jComponent) {
        this.renderer = null;
        super.uninstallUI(jComponent);
    }

    protected void installComponents() {
        if (this.scrollableTabLayoutEnabled() && this.tabScroller == null) {
            this.tabScroller = new PlasticTabbedPaneUI$ScrollableTabSupport(this, this.tabPane.getTabPlacement());
            this.tabPane.add(this.tabScroller.viewport);
        }
    }

    protected void uninstallComponents() {
        if (this.scrollableTabLayoutEnabled()) {
            this.tabPane.remove(this.tabScroller.viewport);
            this.tabPane.remove(this.tabScroller.scrollForwardButton);
            this.tabPane.remove(this.tabScroller.scrollBackwardButton);
            this.tabScroller = null;
        }
    }

    protected void installListeners() {
        super.installListeners();
        if (this.mouseListener != null && LookUtils.IS_JAVA_1_4 && this.scrollableTabLayoutEnabled()) {
            this.tabPane.removeMouseListener(this.mouseListener);
            this.tabScroller.tabPanel.addMouseListener(this.mouseListener);
        }
    }

    protected void uninstallListeners() {
        if (this.mouseListener != null && LookUtils.IS_JAVA_1_4) {
            if (this.scrollableTabLayoutEnabled()) {
                this.tabScroller.tabPanel.removeMouseListener(this.mouseListener);
            } else {
                this.tabPane.removeMouseListener(this.mouseListener);
            }
            this.mouseListener = null;
        }
        super.uninstallListeners();
    }

    protected void installKeyboardActions() {
        super.installKeyboardActions();
        if (this.scrollableTabLayoutEnabled()) {
            PlasticTabbedPaneUI$ScrollTabsForwardAction plasticTabbedPaneUI$ScrollTabsForwardAction = new PlasticTabbedPaneUI$ScrollTabsForwardAction(null);
            PlasticTabbedPaneUI$ScrollTabsBackwardAction plasticTabbedPaneUI$ScrollTabsBackwardAction = new PlasticTabbedPaneUI$ScrollTabsBackwardAction(null);
            ActionMap actionMap = SwingUtilities.getUIActionMap(this.tabPane);
            actionMap.put("scrollTabsForwardAction", plasticTabbedPaneUI$ScrollTabsForwardAction);
            actionMap.put("scrollTabsBackwardAction", plasticTabbedPaneUI$ScrollTabsBackwardAction);
            this.tabScroller.scrollForwardButton.setAction(plasticTabbedPaneUI$ScrollTabsForwardAction);
            this.tabScroller.scrollBackwardButton.setAction(plasticTabbedPaneUI$ScrollTabsBackwardAction);
        }
    }

    private boolean hasNoContentBorder() {
        return Boolean.TRUE.equals(this.noContentBorder);
    }

    private boolean hasEmbeddedTabs() {
        return Boolean.TRUE.equals(this.embeddedTabs);
    }

    private PlasticTabbedPaneUI$AbstractRenderer createRenderer(JTabbedPane jTabbedPane) {
        return this.hasEmbeddedTabs() ? PlasticTabbedPaneUI$AbstractRenderer.access$200(jTabbedPane) : PlasticTabbedPaneUI$AbstractRenderer.access$300(this.tabPane);
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return new PlasticTabbedPaneUI$MyPropertyChangeHandler(this, null);
    }

    protected ChangeListener createChangeListener() {
        return new PlasticTabbedPaneUI$TabSelectionHandler(this, null);
    }

    private void doLayout() {
        this.tabPane.revalidate();
        this.tabPane.repaint();
    }

    private void tabPlacementChanged() {
        this.renderer = this.createRenderer(this.tabPane);
        if (this.scrollableTabLayoutEnabled()) {
            this.tabScroller.createButtons();
        }
        this.doLayout();
    }

    private void embeddedTabsPropertyChanged(Boolean bl2) {
        this.embeddedTabs = bl2;
        this.renderer = this.createRenderer(this.tabPane);
        this.doLayout();
    }

    private void noContentBorderPropertyChanged(Boolean bl2) {
        this.noContentBorder = bl2;
        this.tabPane.repaint();
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        int n2 = this.tabPane.getSelectedIndex();
        int n3 = this.tabPane.getTabPlacement();
        this.ensureCurrentLayout();
        if (!this.scrollableTabLayoutEnabled()) {
            this.paintTabArea(graphics, n3, n2);
        }
        this.paintContentBorder(graphics, n3, n2);
    }

    protected void paintTab(Graphics graphics, int n2, Rectangle[] rectangleArray, int n3, Rectangle rectangle, Rectangle rectangle2) {
        Object object;
        Rectangle rectangle3 = rectangleArray[n3];
        int n4 = this.tabPane.getSelectedIndex();
        boolean bl2 = n4 == n3;
        Graphics2D graphics2D = null;
        Polygon polygon = null;
        Shape shape = null;
        int n5 = 0;
        int n6 = 0;
        if (this.scrollableTabLayoutEnabled() && graphics instanceof Graphics2D) {
            graphics2D = (Graphics2D)graphics;
            object = this.tabScroller.viewport.getViewRect();
            switch (n2) {
                case 2: 
                case 4: {
                    int n7 = ((Rectangle)object).y + ((Rectangle)object).height;
                    if (rectangle3.y >= n7 || rectangle3.y + rectangle3.height <= n7) break;
                    polygon = this.createCroppedTabClip(n2, rectangle3, n7);
                    n5 = rectangle3.x;
                    n6 = n7 - 1;
                    break;
                }
                default: {
                    int n7 = ((Rectangle)object).x + ((Rectangle)object).width;
                    if (rectangle3.x >= n7 || rectangle3.x + rectangle3.width <= n7) break;
                    polygon = this.createCroppedTabClip(n2, rectangle3, n7);
                    n5 = n7 - 1;
                    n6 = rectangle3.y;
                }
            }
            if (polygon != null) {
                shape = graphics.getClip();
                graphics2D.clip(polygon);
            }
        }
        this.paintTabBackground(graphics, n2, n3, rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height, bl2);
        this.paintTabBorder(graphics, n2, n3, rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height, bl2);
        object = this.tabPane.getTitleAt(n3);
        Font font = this.tabPane.getFont();
        FontMetrics fontMetrics = graphics.getFontMetrics(font);
        Icon icon = this.getIconForTab(n3);
        this.layoutLabel(n2, fontMetrics, n3, (String)object, icon, rectangle3, rectangle, rectangle2, bl2);
        this.paintText(graphics, n2, font, fontMetrics, n3, (String)object, rectangle2, bl2);
        this.paintIcon(graphics, n2, n3, icon, rectangle, bl2);
        this.paintFocusIndicator(graphics, n2, rectangleArray, n3, rectangle, rectangle2, bl2);
        if (polygon != null) {
            this.paintCroppedTabEdge(graphics, n2, n3, bl2, n5, n6);
            graphics.setClip(shape);
        }
    }

    private Polygon createCroppedTabClip(int n2, Rectangle rectangle, int n3) {
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        switch (n2) {
            case 2: 
            case 4: {
                n4 = rectangle.width;
                n5 = rectangle.x;
                n6 = rectangle.x + rectangle.width;
                n7 = rectangle.y;
                break;
            }
            default: {
                n4 = rectangle.height;
                n5 = rectangle.y;
                n6 = rectangle.y + rectangle.height;
                n7 = rectangle.x;
            }
        }
        int n8 = n4 / 12;
        if (n4 % 12 > 0) {
            ++n8;
        }
        int n9 = 2 + n8 * 8;
        int[] nArray = new int[n9];
        int[] nArray2 = new int[n9];
        int n10 = 0;
        nArray[n10] = n7;
        nArray2[n10++] = n6;
        nArray[n10] = n7;
        nArray2[n10++] = n5;
        block3: for (int i2 = 0; i2 < n8; ++i2) {
            for (int i3 = 0; i3 < this.xCropLen.length; ++i3) {
                nArray[n10] = n3 - this.xCropLen[i3];
                nArray2[n10] = n5 + i2 * 12 + this.yCropLen[i3];
                if (nArray2[n10] >= n6) {
                    nArray2[n10] = n6;
                    ++n10;
                    continue block3;
                }
                ++n10;
            }
        }
        if (n2 == 1 || n2 == 3) {
            return new Polygon(nArray, nArray2, n10);
        }
        return new Polygon(nArray2, nArray, n10);
    }

    private void paintCroppedTabEdge(Graphics graphics, int n2, int n3, boolean bl2, int n4, int n5) {
        switch (n2) {
            case 2: 
            case 4: {
                graphics.setColor(this.shadow);
                for (int i2 = n4; i2 <= n4 + this.rects[n3].width; i2 += 12) {
                    for (int i3 = 0; i3 < this.xCropLen.length; i3 += 2) {
                        graphics.drawLine(i2 + this.yCropLen[i3], n5 - this.xCropLen[i3], i2 + this.yCropLen[i3 + 1] - 1, n5 - this.xCropLen[i3 + 1]);
                    }
                }
                break;
            }
            default: {
                graphics.setColor(this.shadow);
                for (int i4 = n5; i4 <= n5 + this.rects[n3].height; i4 += 12) {
                    for (int i5 = 0; i5 < this.xCropLen.length; i5 += 2) {
                        graphics.drawLine(n4 - this.xCropLen[i5], i4 + this.yCropLen[i5], n4 - this.xCropLen[i5 + 1], i4 + this.yCropLen[i5 + 1] - 1);
                    }
                }
            }
        }
    }

    private void ensureCurrentLayout() {
        if (!this.tabPane.isValid()) {
            this.tabPane.validate();
        }
        if (!this.tabPane.isValid()) {
            PlasticTabbedPaneUI$TabbedPaneLayout plasticTabbedPaneUI$TabbedPaneLayout = (PlasticTabbedPaneUI$TabbedPaneLayout)this.tabPane.getLayout();
            plasticTabbedPaneUI$TabbedPaneLayout.calculateLayoutInfo();
        }
    }

    public int tabForCoordinate(JTabbedPane jTabbedPane, int n2, int n3) {
        this.ensureCurrentLayout();
        Point point = new Point(n2, n3);
        if (this.scrollableTabLayoutEnabled()) {
            this.translatePointToTabPanel(n2, n3, point);
            Rectangle rectangle = this.tabScroller.viewport.getViewRect();
            if (!rectangle.contains(point)) {
                return -1;
            }
        }
        int n4 = this.tabPane.getTabCount();
        for (int i2 = 0; i2 < n4; ++i2) {
            if (!this.rects[i2].contains(point.x, point.y)) continue;
            return i2;
        }
        return -1;
    }

    protected Rectangle getTabBounds(int n2, Rectangle rectangle) {
        rectangle.width = this.rects[n2].width;
        rectangle.height = this.rects[n2].height;
        if (this.scrollableTabLayoutEnabled()) {
            Point point = this.tabScroller.viewport.getLocation();
            Point point2 = this.tabScroller.viewport.getViewPosition();
            rectangle.x = this.rects[n2].x + point.x - point2.x;
            rectangle.y = this.rects[n2].y + point.y - point2.y;
        } else {
            rectangle.x = this.rects[n2].x;
            rectangle.y = this.rects[n2].y;
        }
        return rectangle;
    }

    private int getClosestTab(int n2, int n3) {
        int n4;
        int n5;
        int n6 = 0;
        int n7 = n5 = Math.min(this.rects.length, this.tabPane.getTabCount());
        int n8 = this.tabPane.getTabPlacement();
        boolean bl2 = n8 == 1 || n8 == 3;
        int n9 = n4 = bl2 ? n2 : n3;
        while (n6 != n7) {
            int n10;
            int n11;
            int n12 = (n7 + n6) / 2;
            if (bl2) {
                n11 = this.rects[n12].x;
                n10 = n11 + this.rects[n12].width;
            } else {
                n11 = this.rects[n12].y;
                n10 = n11 + this.rects[n12].height;
            }
            if (n4 < n11) {
                n7 = n12;
                if (n6 != n7) continue;
                return Math.max(0, n12 - 1);
            }
            if (n4 >= n10) {
                n6 = n12;
                if (n7 - n6 > 1) continue;
                return Math.max(n12 + 1, n5 - 1);
            }
            return n12;
        }
        return n6;
    }

    private Point translatePointToTabPanel(int n2, int n3, Point point) {
        Point point2 = this.tabScroller.viewport.getLocation();
        Point point3 = this.tabScroller.viewport.getViewPosition();
        point.x = n2 - point2.x + point3.x;
        point.y = n3 - point2.y + point3.y;
        return point;
    }

    protected void paintTabArea(Graphics graphics, int n2, int n3) {
        int n4 = this.tabPane.getTabCount();
        Rectangle rectangle = new Rectangle();
        Rectangle rectangle2 = new Rectangle();
        Rectangle rectangle3 = graphics.getClipBounds();
        for (int i2 = this.runCount - 1; i2 >= 0; --i2) {
            int n5;
            int n6 = this.tabRuns[i2];
            int n7 = this.tabRuns[i2 == this.runCount - 1 ? 0 : i2 + 1];
            for (int i3 = n5 = n7 != 0 ? n7 - 1 : n4 - 1; i3 >= n6; --i3) {
                if (i3 == n3 || !this.rects[i3].intersects(rectangle3)) continue;
                this.paintTab(graphics, n2, this.rects, i3, rectangle, rectangle2);
            }
        }
        if (n3 >= 0 && this.rects[n3].intersects(rectangle3)) {
            this.paintTab(graphics, n2, this.rects, n3, rectangle, rectangle2);
        }
    }

    protected void layoutLabel(int n2, FontMetrics fontMetrics, int n3, String string, Icon icon, Rectangle rectangle, Rectangle rectangle2, Rectangle rectangle3, boolean bl2) {
        rectangle2.y = 0;
        rectangle2.x = 0;
        rectangle3.y = 0;
        rectangle3.x = 0;
        View view = this.getTextViewForTab(n3);
        if (view != null) {
            this.tabPane.putClientProperty("html", view);
        }
        Rectangle rectangle4 = new Rectangle(rectangle);
        if (bl2) {
            Insets insets = this.getSelectedTabPadInsets(n2);
            rectangle4.x += insets.left;
            rectangle4.y += insets.top;
            rectangle4.width -= insets.left + insets.right;
            rectangle4.height -= insets.bottom + insets.top;
        }
        int n4 = this.getTabLabelShiftX(n2, n3, bl2);
        int n5 = this.getTabLabelShiftY(n2, n3, bl2);
        if (!(n2 != 4 && n2 != 2 || icon == null || string == null || string.equals(""))) {
            SwingUtilities.layoutCompoundLabel(this.tabPane, fontMetrics, string, icon, 0, 2, 0, 11, rectangle4, rectangle2, rectangle3, this.textIconGap);
            n4 += 4;
        } else {
            SwingUtilities.layoutCompoundLabel(this.tabPane, fontMetrics, string, icon, 0, 0, 0, 11, rectangle4, rectangle2, rectangle3, this.textIconGap);
            rectangle2.y += rectangle4.height % 2;
        }
        this.tabPane.putClientProperty("html", null);
        rectangle2.x += n4;
        rectangle2.y += n5;
        rectangle3.x += n4;
        rectangle3.y += n5;
    }

    protected Icon getIconForTab(int n2) {
        String string = this.tabPane.getTitleAt(n2);
        boolean bl2 = string != null && string.length() > 0;
        return !isTabIconsEnabled && bl2 ? null : super.getIconForTab(n2);
    }

    protected LayoutManager createLayoutManager() {
        if (this.tabPane.getTabLayoutPolicy() == 1) {
            return new PlasticTabbedPaneUI$TabbedPaneScrollLayout(this, null);
        }
        return new PlasticTabbedPaneUI$TabbedPaneLayout(this, null);
    }

    private boolean scrollableTabLayoutEnabled() {
        return this.tabPane.getLayout() instanceof PlasticTabbedPaneUI$TabbedPaneScrollLayout;
    }

    protected boolean isTabInFirstRun(int n2) {
        return this.getRunForTab(this.tabPane.getTabCount(), n2) == 0;
    }

    protected void paintContentBorder(Graphics graphics, int n2, int n3) {
        int n4 = this.tabPane.getWidth();
        int n5 = this.tabPane.getHeight();
        Insets insets = this.tabPane.getInsets();
        int n6 = insets.left;
        int n7 = insets.top;
        int n8 = n4 - insets.right - insets.left;
        int n9 = n5 - insets.top - insets.bottom;
        switch (n2) {
            case 2: {
                n8 -= (n6 += this.calculateTabAreaWidth(n2, this.runCount, this.maxTabWidth)) - insets.left;
                break;
            }
            case 4: {
                n8 -= this.calculateTabAreaWidth(n2, this.runCount, this.maxTabWidth);
                break;
            }
            case 3: {
                n9 -= this.calculateTabAreaHeight(n2, this.runCount, this.maxTabHeight);
                break;
            }
            default: {
                n9 -= (n7 += this.calculateTabAreaHeight(n2, this.runCount, this.maxTabHeight)) - insets.top;
            }
        }
        graphics.setColor(this.selectColor == null ? this.tabPane.getBackground() : this.selectColor);
        graphics.fillRect(n6, n7, n8, n9);
        Rectangle rectangle = n3 < 0 ? null : this.getTabBounds(n3, this.calcRect);
        boolean bl2 = n3 >= 0 && this.isTabInFirstRun(n3);
        boolean bl3 = !this.hasNoContentBorder();
        this.renderer.paintContentBorderTopEdge(graphics, n6, n7, n8, n9, bl2, rectangle, bl3);
        this.renderer.paintContentBorderLeftEdge(graphics, n6, n7, n8, n9, bl2, rectangle, bl3);
        this.renderer.paintContentBorderBottomEdge(graphics, n6, n7, n8, n9, bl2, rectangle, bl3);
        this.renderer.paintContentBorderRightEdge(graphics, n6, n7, n8, n9, bl2, rectangle, bl3);
    }

    protected Insets getContentBorderInsets(int n2) {
        return this.renderer.getContentBorderInsets(super.getContentBorderInsets(n2));
    }

    protected Insets getTabAreaInsets(int n2) {
        return this.renderer.getTabAreaInsets(super.getTabAreaInsets(n2));
    }

    protected int getTabLabelShiftX(int n2, int n3, boolean bl2) {
        return this.renderer.getTabLabelShiftX(n3, bl2);
    }

    protected int getTabLabelShiftY(int n2, int n3, boolean bl2) {
        return this.renderer.getTabLabelShiftY(n3, bl2);
    }

    protected int getTabRunOverlay(int n2) {
        return this.renderer.getTabRunOverlay(this.tabRunOverlay);
    }

    protected boolean shouldPadTabRun(int n2, int n3) {
        return this.renderer.shouldPadTabRun(n3, super.shouldPadTabRun(n2, n3));
    }

    protected int getTabRunIndent(int n2, int n3) {
        return this.renderer.getTabRunIndent(n3);
    }

    protected Insets getTabInsets(int n2, int n3) {
        return this.renderer.getTabInsets(n3, this.tabInsets);
    }

    protected Insets getSelectedTabPadInsets(int n2) {
        return this.renderer.getSelectedTabPadInsets();
    }

    protected void paintFocusIndicator(Graphics graphics, int n2, Rectangle[] rectangleArray, int n3, Rectangle rectangle, Rectangle rectangle2, boolean bl2) {
        this.renderer.paintFocusIndicator(graphics, rectangleArray, n3, rectangle, rectangle2, bl2);
    }

    protected void paintTabBackground(Graphics graphics, int n2, int n3, int n4, int n5, int n6, int n7, boolean bl2) {
        this.renderer.paintTabBackground(graphics, n3, n4, n5, n6, n7, bl2);
    }

    protected void paintTabBorder(Graphics graphics, int n2, int n3, int n4, int n5, int n6, int n7, boolean bl2) {
        this.renderer.paintTabBorder(graphics, n3, n4, n5, n6, n7, bl2);
    }

    protected boolean shouldRotateTabRuns(int n2) {
        return false;
    }

    private boolean requestFocusForVisibleComponent() {
        Component component = this.getVisibleComponent();
        if (component.isFocusable()) {
            component.requestFocus();
            return true;
        }
        return component instanceof JComponent && ((JComponent)component).requestDefaultFocus();
    }

    static /* synthetic */ Rectangle[] access$800(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.rects;
    }

    static /* synthetic */ Rectangle[] access$900(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.rects;
    }

    static /* synthetic */ PlasticTabbedPaneUI$ScrollableTabSupport access$1000(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.tabScroller;
    }

    static /* synthetic */ PlasticTabbedPaneUI$AbstractRenderer access$1100(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.renderer;
    }

    static /* synthetic */ void access$1200(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        plasticTabbedPaneUI.tabPlacementChanged();
    }

    static /* synthetic */ void access$1300(PlasticTabbedPaneUI plasticTabbedPaneUI, Boolean bl2) {
        plasticTabbedPaneUI.embeddedTabsPropertyChanged(bl2);
    }

    static /* synthetic */ void access$1400(PlasticTabbedPaneUI plasticTabbedPaneUI, Boolean bl2) {
        plasticTabbedPaneUI.noContentBorderPropertyChanged(bl2);
    }

    static /* synthetic */ FontMetrics access$1500(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.getFontMetrics();
    }

    static /* synthetic */ JTabbedPane access$1600(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.tabPane;
    }

    static /* synthetic */ JTabbedPane access$1700(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.tabPane;
    }

    static /* synthetic */ JTabbedPane access$1800(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.tabPane;
    }

    static /* synthetic */ JTabbedPane access$1900(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.tabPane;
    }

    static /* synthetic */ int access$2002(PlasticTabbedPaneUI plasticTabbedPaneUI, int n2) {
        plasticTabbedPaneUI.maxTabWidth = n2;
        return plasticTabbedPaneUI.maxTabWidth;
    }

    static /* synthetic */ int access$2100(PlasticTabbedPaneUI plasticTabbedPaneUI, int n2) {
        return plasticTabbedPaneUI.calculateMaxTabWidth(n2);
    }

    static /* synthetic */ int access$2202(PlasticTabbedPaneUI plasticTabbedPaneUI, int n2) {
        plasticTabbedPaneUI.maxTabWidth = n2;
        return plasticTabbedPaneUI.maxTabWidth;
    }

    static /* synthetic */ int access$2300(PlasticTabbedPaneUI plasticTabbedPaneUI, int n2) {
        return plasticTabbedPaneUI.calculateMaxTabWidth(n2);
    }

    static /* synthetic */ int access$2400(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.maxTabWidth;
    }

    static /* synthetic */ int access$2502(PlasticTabbedPaneUI plasticTabbedPaneUI, int n2) {
        plasticTabbedPaneUI.maxTabHeight = n2;
        return plasticTabbedPaneUI.maxTabHeight;
    }

    static /* synthetic */ int access$2600(PlasticTabbedPaneUI plasticTabbedPaneUI, int n2) {
        return plasticTabbedPaneUI.calculateMaxTabHeight(n2);
    }

    static /* synthetic */ int access$2700(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.maxTabHeight;
    }

    static /* synthetic */ int access$2802(PlasticTabbedPaneUI plasticTabbedPaneUI, int n2) {
        plasticTabbedPaneUI.maxTabHeight = n2;
        return plasticTabbedPaneUI.maxTabHeight;
    }

    static /* synthetic */ int access$2900(PlasticTabbedPaneUI plasticTabbedPaneUI, int n2) {
        return plasticTabbedPaneUI.calculateMaxTabHeight(n2);
    }

    static /* synthetic */ int access$3002(PlasticTabbedPaneUI plasticTabbedPaneUI, int n2) {
        plasticTabbedPaneUI.runCount = n2;
        return plasticTabbedPaneUI.runCount;
    }

    static /* synthetic */ int access$3102(PlasticTabbedPaneUI plasticTabbedPaneUI, int n2) {
        plasticTabbedPaneUI.selectedRun = n2;
        return plasticTabbedPaneUI.selectedRun;
    }

    static /* synthetic */ Rectangle[] access$3200(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.rects;
    }

    static /* synthetic */ Rectangle[] access$3300(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.rects;
    }

    static /* synthetic */ Rectangle[] access$3400(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.rects;
    }

    static /* synthetic */ int[] access$3500(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.tabRuns;
    }

    static /* synthetic */ int access$3602(PlasticTabbedPaneUI plasticTabbedPaneUI, int n2) {
        plasticTabbedPaneUI.runCount = n2;
        return plasticTabbedPaneUI.runCount;
    }

    static /* synthetic */ int access$3702(PlasticTabbedPaneUI plasticTabbedPaneUI, int n2) {
        plasticTabbedPaneUI.maxTabWidth = n2;
        return plasticTabbedPaneUI.maxTabWidth;
    }

    static /* synthetic */ int access$3800(PlasticTabbedPaneUI plasticTabbedPaneUI, int n2, int n3, FontMetrics fontMetrics) {
        return plasticTabbedPaneUI.calculateTabWidth(n2, n3, fontMetrics);
    }

    static /* synthetic */ int access$3902(PlasticTabbedPaneUI plasticTabbedPaneUI, int n2) {
        plasticTabbedPaneUI.maxTabWidth = n2;
        return plasticTabbedPaneUI.maxTabWidth;
    }

    static /* synthetic */ int access$4000(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.maxTabWidth;
    }

    static /* synthetic */ int access$4100(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.runCount;
    }

    static /* synthetic */ int[] access$4200(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.tabRuns;
    }

    static /* synthetic */ void access$4300(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        plasticTabbedPaneUI.expandTabRunsArray();
    }

    static /* synthetic */ int[] access$4400(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.tabRuns;
    }

    static /* synthetic */ int access$4500(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.runCount;
    }

    static /* synthetic */ int access$4608(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.runCount++;
    }

    static /* synthetic */ int access$4700(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.runCount;
    }

    static /* synthetic */ int access$4800(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.maxTabHeight;
    }

    static /* synthetic */ Rectangle[] access$4900(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.rects;
    }

    static /* synthetic */ Rectangle[] access$5000(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.rects;
    }

    static /* synthetic */ int[] access$5100(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.tabRuns;
    }

    static /* synthetic */ int access$5202(PlasticTabbedPaneUI plasticTabbedPaneUI, int n2) {
        plasticTabbedPaneUI.runCount = n2;
        return plasticTabbedPaneUI.runCount;
    }

    static /* synthetic */ int access$5302(PlasticTabbedPaneUI plasticTabbedPaneUI, int n2) {
        plasticTabbedPaneUI.maxTabHeight = n2;
        return plasticTabbedPaneUI.maxTabHeight;
    }

    static /* synthetic */ int access$5400(PlasticTabbedPaneUI plasticTabbedPaneUI, int n2, int n3, int n4) {
        return plasticTabbedPaneUI.calculateTabHeight(n2, n3, n4);
    }

    static /* synthetic */ int access$5502(PlasticTabbedPaneUI plasticTabbedPaneUI, int n2) {
        plasticTabbedPaneUI.maxTabHeight = n2;
        return plasticTabbedPaneUI.maxTabHeight;
    }

    static /* synthetic */ int access$5600(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.maxTabHeight;
    }

    static /* synthetic */ int access$5700(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.runCount;
    }

    static /* synthetic */ int[] access$5800(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.tabRuns;
    }

    static /* synthetic */ void access$5900(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        plasticTabbedPaneUI.expandTabRunsArray();
    }

    static /* synthetic */ int[] access$6000(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.tabRuns;
    }

    static /* synthetic */ int access$6100(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.runCount;
    }

    static /* synthetic */ int access$6208(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.runCount++;
    }

    static /* synthetic */ int access$6300(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.runCount;
    }

    static /* synthetic */ int access$6400(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.maxTabWidth;
    }

    static /* synthetic */ int access$6502(PlasticTabbedPaneUI plasticTabbedPaneUI, int n2) {
        plasticTabbedPaneUI.selectedRun = n2;
        return plasticTabbedPaneUI.selectedRun;
    }

    static /* synthetic */ int access$6600(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.runCount;
    }

    static /* synthetic */ int access$6700(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.runCount;
    }

    static /* synthetic */ int access$6800(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.selectedRun;
    }

    static /* synthetic */ int access$6900(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.runCount;
    }

    static /* synthetic */ int[] access$7000(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.tabRuns;
    }

    static /* synthetic */ int[] access$7100(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.tabRuns;
    }

    static /* synthetic */ int access$7200(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.runCount;
    }

    static /* synthetic */ Rectangle[] access$7300(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.rects;
    }

    static /* synthetic */ int access$7400(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.maxTabHeight;
    }

    static /* synthetic */ int access$7500(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.maxTabHeight;
    }

    static /* synthetic */ Rectangle[] access$7600(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.rects;
    }

    static /* synthetic */ int access$7700(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.maxTabWidth;
    }

    static /* synthetic */ int access$7800(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.maxTabWidth;
    }

    static /* synthetic */ Rectangle[] access$7900(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.rects;
    }

    static /* synthetic */ Rectangle[] access$8000(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.rects;
    }

    static /* synthetic */ Rectangle[] access$8100(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.rects;
    }

    static /* synthetic */ Rectangle[] access$8200(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.rects;
    }

    static /* synthetic */ boolean access$8300(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.scrollableTabLayoutEnabled();
    }

    static /* synthetic */ int access$8400(PlasticTabbedPaneUI plasticTabbedPaneUI, int n2) {
        return plasticTabbedPaneUI.calculateMaxTabHeight(n2);
    }

    static /* synthetic */ int access$8500(PlasticTabbedPaneUI plasticTabbedPaneUI, int n2) {
        return plasticTabbedPaneUI.calculateMaxTabWidth(n2);
    }

    static /* synthetic */ JTabbedPane access$8600(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.tabPane;
    }

    static /* synthetic */ JTabbedPane access$8700(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.tabPane;
    }

    static /* synthetic */ JTabbedPane access$8800(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.tabPane;
    }

    static /* synthetic */ JTabbedPane access$8900(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.tabPane;
    }

    static /* synthetic */ Component access$9000(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.getVisibleComponent();
    }

    static /* synthetic */ void access$9100(PlasticTabbedPaneUI plasticTabbedPaneUI, Component component) {
        plasticTabbedPaneUI.setVisibleComponent(component);
    }

    static /* synthetic */ JTabbedPane access$9200(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.tabPane;
    }

    static /* synthetic */ void access$9300(PlasticTabbedPaneUI plasticTabbedPaneUI, Component component) {
        plasticTabbedPaneUI.setVisibleComponent(component);
    }

    static /* synthetic */ JTabbedPane access$9400(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.tabPane;
    }

    static /* synthetic */ JTabbedPane access$9500(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.tabPane;
    }

    static /* synthetic */ int access$9600(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.runCount;
    }

    static /* synthetic */ int access$9700(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.maxTabWidth;
    }

    static /* synthetic */ int access$9800(PlasticTabbedPaneUI plasticTabbedPaneUI, int n2, int n3, int n4) {
        return plasticTabbedPaneUI.calculateTabAreaWidth(n2, n3, n4);
    }

    static /* synthetic */ int access$9900(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.runCount;
    }

    static /* synthetic */ int access$10000(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.maxTabWidth;
    }

    static /* synthetic */ int access$10100(PlasticTabbedPaneUI plasticTabbedPaneUI, int n2, int n3, int n4) {
        return plasticTabbedPaneUI.calculateTabAreaWidth(n2, n3, n4);
    }

    static /* synthetic */ int access$10200(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.runCount;
    }

    static /* synthetic */ int access$10300(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.maxTabHeight;
    }

    static /* synthetic */ int access$10400(PlasticTabbedPaneUI plasticTabbedPaneUI, int n2, int n3, int n4) {
        return plasticTabbedPaneUI.calculateTabAreaHeight(n2, n3, n4);
    }

    static /* synthetic */ int access$10500(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.runCount;
    }

    static /* synthetic */ int access$10600(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.maxTabHeight;
    }

    static /* synthetic */ int access$10700(PlasticTabbedPaneUI plasticTabbedPaneUI, int n2, int n3, int n4) {
        return plasticTabbedPaneUI.calculateTabAreaHeight(n2, n3, n4);
    }

    static /* synthetic */ JTabbedPane access$10800(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.tabPane;
    }

    static /* synthetic */ Rectangle[] access$10900(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.rects;
    }

    static /* synthetic */ Rectangle[] access$11000(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.rects;
    }

    static /* synthetic */ Rectangle[] access$11100(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.rects;
    }

    static /* synthetic */ Rectangle[] access$11200(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.rects;
    }

    static /* synthetic */ Rectangle[] access$11300(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.rects;
    }

    static /* synthetic */ Rectangle[] access$11400(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.rects;
    }

    static /* synthetic */ Rectangle[] access$11500(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.rects;
    }

    static /* synthetic */ Rectangle[] access$11600(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.rects;
    }

    static /* synthetic */ boolean access$11700(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.requestFocusForVisibleComponent();
    }

    static /* synthetic */ JTabbedPane access$11800(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.tabPane;
    }

    static /* synthetic */ FontMetrics access$11900(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.getFontMetrics();
    }

    static /* synthetic */ JTabbedPane access$12000(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.tabPane;
    }

    static /* synthetic */ JTabbedPane access$12100(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.tabPane;
    }

    static /* synthetic */ JTabbedPane access$12200(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.tabPane;
    }

    static /* synthetic */ JTabbedPane access$12300(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.tabPane;
    }

    static /* synthetic */ int access$12402(PlasticTabbedPaneUI plasticTabbedPaneUI, int n2) {
        plasticTabbedPaneUI.maxTabWidth = n2;
        return plasticTabbedPaneUI.maxTabWidth;
    }

    static /* synthetic */ int access$12500(PlasticTabbedPaneUI plasticTabbedPaneUI, int n2) {
        return plasticTabbedPaneUI.calculateMaxTabWidth(n2);
    }

    static /* synthetic */ int access$12602(PlasticTabbedPaneUI plasticTabbedPaneUI, int n2) {
        plasticTabbedPaneUI.maxTabHeight = n2;
        return plasticTabbedPaneUI.maxTabHeight;
    }

    static /* synthetic */ int access$12700(PlasticTabbedPaneUI plasticTabbedPaneUI, int n2) {
        return plasticTabbedPaneUI.calculateMaxTabHeight(n2);
    }

    static /* synthetic */ int access$12802(PlasticTabbedPaneUI plasticTabbedPaneUI, int n2) {
        plasticTabbedPaneUI.runCount = n2;
        return plasticTabbedPaneUI.runCount;
    }

    static /* synthetic */ int access$12902(PlasticTabbedPaneUI plasticTabbedPaneUI, int n2) {
        plasticTabbedPaneUI.selectedRun = n2;
        return plasticTabbedPaneUI.selectedRun;
    }

    static /* synthetic */ int access$13002(PlasticTabbedPaneUI plasticTabbedPaneUI, int n2) {
        plasticTabbedPaneUI.selectedRun = n2;
        return plasticTabbedPaneUI.selectedRun;
    }

    static /* synthetic */ int access$13102(PlasticTabbedPaneUI plasticTabbedPaneUI, int n2) {
        plasticTabbedPaneUI.runCount = n2;
        return plasticTabbedPaneUI.runCount;
    }

    static /* synthetic */ Rectangle[] access$13200(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.rects;
    }

    static /* synthetic */ Rectangle[] access$13300(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.rects;
    }

    static /* synthetic */ Rectangle[] access$13400(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.rects;
    }

    static /* synthetic */ int[] access$13500(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.tabRuns;
    }

    static /* synthetic */ int access$13602(PlasticTabbedPaneUI plasticTabbedPaneUI, int n2) {
        plasticTabbedPaneUI.maxTabWidth = n2;
        return plasticTabbedPaneUI.maxTabWidth;
    }

    static /* synthetic */ int access$13700(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.maxTabHeight;
    }

    static /* synthetic */ int access$13800(PlasticTabbedPaneUI plasticTabbedPaneUI, int n2, int n3, FontMetrics fontMetrics) {
        return plasticTabbedPaneUI.calculateTabWidth(n2, n3, fontMetrics);
    }

    static /* synthetic */ int access$13902(PlasticTabbedPaneUI plasticTabbedPaneUI, int n2) {
        plasticTabbedPaneUI.maxTabWidth = n2;
        return plasticTabbedPaneUI.maxTabWidth;
    }

    static /* synthetic */ int access$14000(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.maxTabWidth;
    }

    static /* synthetic */ int access$14100(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.maxTabHeight;
    }

    static /* synthetic */ Rectangle[] access$14200(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.rects;
    }

    static /* synthetic */ Rectangle[] access$14300(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.rects;
    }

    static /* synthetic */ int[] access$14400(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.tabRuns;
    }

    static /* synthetic */ int access$14502(PlasticTabbedPaneUI plasticTabbedPaneUI, int n2) {
        plasticTabbedPaneUI.maxTabHeight = n2;
        return plasticTabbedPaneUI.maxTabHeight;
    }

    static /* synthetic */ int access$14600(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.maxTabWidth;
    }

    static /* synthetic */ int access$14700(PlasticTabbedPaneUI plasticTabbedPaneUI, int n2, int n3, int n4) {
        return plasticTabbedPaneUI.calculateTabHeight(n2, n3, n4);
    }

    static /* synthetic */ int access$14802(PlasticTabbedPaneUI plasticTabbedPaneUI, int n2) {
        plasticTabbedPaneUI.maxTabHeight = n2;
        return plasticTabbedPaneUI.maxTabHeight;
    }

    static /* synthetic */ int access$14900(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.maxTabHeight;
    }

    static /* synthetic */ int access$15000(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.maxTabWidth;
    }

    static /* synthetic */ Rectangle[] access$15100(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.rects;
    }

    static /* synthetic */ Rectangle[] access$15200(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.rects;
    }

    static /* synthetic */ Rectangle[] access$15300(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.rects;
    }

    static /* synthetic */ JTabbedPane access$15400(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.tabPane;
    }

    static /* synthetic */ JTabbedPane access$15500(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.tabPane;
    }

    static /* synthetic */ JTabbedPane access$15600(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.tabPane;
    }

    static /* synthetic */ JTabbedPane access$15700(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.tabPane;
    }

    static /* synthetic */ JTabbedPane access$15800(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.tabPane;
    }

    static /* synthetic */ Rectangle[] access$15900(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.rects;
    }

    static /* synthetic */ Rectangle[] access$16000(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.rects;
    }

    static /* synthetic */ JTabbedPane access$16100(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.tabPane;
    }

    static /* synthetic */ JTabbedPane access$16200(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.tabPane;
    }

    static /* synthetic */ int access$16300(PlasticTabbedPaneUI plasticTabbedPaneUI, int n2, int n3) {
        return plasticTabbedPaneUI.getClosestTab(n2, n3);
    }

    static /* synthetic */ Rectangle[] access$16400(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.rects;
    }

    static /* synthetic */ Rectangle[] access$16500(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.rects;
    }

    static /* synthetic */ JTabbedPane access$16600(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.tabPane;
    }

    static /* synthetic */ JTabbedPane access$16700(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.tabPane;
    }

    static /* synthetic */ JTabbedPane access$16800(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.tabPane;
    }

    static /* synthetic */ JTabbedPane access$16900(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.tabPane;
    }

    static /* synthetic */ JTabbedPane access$17000(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.tabPane;
    }

    static /* synthetic */ JTabbedPane access$17100(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.tabPane;
    }

    static /* synthetic */ JTabbedPane access$17200(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.tabPane;
    }

    static /* synthetic */ JTabbedPane access$17300(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.tabPane;
    }

    static /* synthetic */ JTabbedPane access$17400(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.tabPane;
    }

    static /* synthetic */ JTabbedPane access$17500(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.tabPane;
    }

    static /* synthetic */ JTabbedPane access$17600(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.tabPane;
    }

    static /* synthetic */ JTabbedPane access$17700(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.tabPane;
    }

    static /* synthetic */ Color access$18600(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.shadow;
    }

    static /* synthetic */ Color access$18700(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.darkShadow;
    }

    static /* synthetic */ Color access$18800(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.selectColor;
    }

    static /* synthetic */ Color access$18900(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.focus;
    }

    static /* synthetic */ Color access$19000(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.selectHighlight;
    }

    static /* synthetic */ Color access$19100(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.lightHighlight;
    }
}

