/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.looks.plastic;

import com.jgoodies.looks.plastic.PlasticTreeUI$LineStyleHandler;
import java.awt.Component;
import java.awt.Graphics;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicTreeUI;

public final class PlasticTreeUI
extends BasicTreeUI {
    private boolean linesEnabled = true;
    private PropertyChangeListener lineStyleHandler;

    public static ComponentUI createUI(JComponent jComponent) {
        return new PlasticTreeUI();
    }

    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        this.updateLineStyle(jComponent.getClientProperty("JTree.lineStyle"));
        this.lineStyleHandler = new PlasticTreeUI$LineStyleHandler(this, null);
        jComponent.addPropertyChangeListener(this.lineStyleHandler);
    }

    public void uninstallUI(JComponent jComponent) {
        jComponent.removePropertyChangeListener(this.lineStyleHandler);
        super.uninstallUI(jComponent);
    }

    protected void paintVerticalLine(Graphics graphics, JComponent jComponent, int n2, int n3, int n4) {
        if (this.linesEnabled) {
            this.drawDashedVerticalLine(graphics, n2, n3, n4);
        }
    }

    protected void paintHorizontalLine(Graphics graphics, JComponent jComponent, int n2, int n3, int n4) {
        if (this.linesEnabled) {
            this.drawDashedHorizontalLine(graphics, n2, n3, n4);
        }
    }

    protected void drawCentered(Component component, Graphics graphics, Icon icon, int n2, int n3) {
        icon.paintIcon(component, graphics, n2 - icon.getIconWidth() / 2 - 1, n3 - icon.getIconHeight() / 2);
    }

    private void updateLineStyle(Object object) {
        this.linesEnabled = !"None".equals(object);
    }

    static /* synthetic */ void access$100(PlasticTreeUI plasticTreeUI, Object object) {
        plasticTreeUI.updateLineStyle(object);
    }
}

