/*
 * Decompiled with CFR 0.152.
 */
package com.jformdesigner.model;

import com.jformdesigner.model.SwingTableColumn;
import java.util.Vector;
import javax.swing.table.DefaultTableModel;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SwingTableModel
extends DefaultTableModel {
    private Vector<Class<?>> columnTypes;
    private Vector<Boolean> columnEditables;
    private Vector<SwingTableColumn> columnInfos;
    static /* synthetic */ Class class$java$lang$Object;

    public SwingTableModel() {
        this.init();
    }

    public SwingTableModel(Vector<Vector<Object>> data, Vector<String> columnNames) {
        this(data, columnNames, null, null);
    }

    public SwingTableModel(Vector<Vector<Object>> data, Vector<String> columnNames, Vector<Class<?>> columnTypes, Vector<Boolean> columnEditables) {
        this(data, columnNames, columnTypes, columnEditables, null);
    }

    public SwingTableModel(Vector<Vector<Object>> data, Vector<String> columnNames, Vector<Class<?>> columnTypes, Vector<Boolean> columnEditables, Vector<SwingTableColumn> columnInfos) {
        super(data, columnNames);
        this.columnTypes = columnTypes;
        this.columnEditables = columnEditables;
        this.columnInfos = columnInfos;
        this.init();
    }

    public SwingTableModel(Object[][] data, Object[] columnNames) {
        super(data, columnNames);
        this.init();
    }

    public SwingTableModel(SwingTableModel model) {
        int rowCount = model.dataVector.size();
        this.dataVector = new Vector(rowCount);
        for (int i = 0; i < rowCount; ++i) {
            this.dataVector.add(((Vector)model.dataVector.get(i)).clone());
        }
        this.columnIdentifiers = (Vector)model.columnIdentifiers.clone();
        this.columnTypes = (Vector)model.columnTypes.clone();
        this.columnEditables = (Vector)model.columnEditables.clone();
        this.columnInfos = (Vector)model.columnInfos.clone();
    }

    private void init() {
        if (this.columnTypes == null) {
            this.columnTypes = new Vector();
            this.columnTypes.setSize(this.getColumnCount());
        }
        if (this.columnEditables == null) {
            this.columnEditables = new Vector();
            this.columnEditables.setSize(this.getColumnCount());
        }
        if (this.columnInfos == null) {
            this.columnInfos = new Vector();
            this.columnInfos.setSize(this.getColumnCount());
        }
    }

    public Vector<String> getColumnNames() {
        return this.columnIdentifiers;
    }

    public Vector<Class<?>> getColumnTypes() {
        return this.columnTypes;
    }

    public Vector<Boolean> getColumnEditables() {
        return this.columnEditables;
    }

    public Vector<SwingTableColumn> getColumnInfos() {
        return this.columnInfos;
    }

    @Override
    public void setColumnCount(int columnCount) {
        this.columnTypes.setSize(columnCount);
        this.columnEditables.setSize(columnCount);
        this.columnInfos.setSize(columnCount);
        super.setColumnCount(columnCount);
    }

    public boolean isColumnEditable(int column) {
        Boolean editable = this.columnEditables.get(column);
        return editable != null ? editable : true;
    }

    public SwingTableColumn getColumnInfo(int column) {
        return this.columnInfos.get(column);
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        Class<?> clazz;
        Class<?> cls = this.columnTypes.get(columnIndex);
        if (cls != null) {
            clazz = cls;
        } else {
            clazz = class$java$lang$Object;
            if (clazz == null) {
                clazz = class$java$lang$Object = new Object[0].getClass().getComponentType();
            }
        }
        return clazz;
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return this.isColumnEditable(column);
    }
}

