/*
 * Decompiled with CFR 0.152.
 */
package com.jformdesigner.runtime;

import com.jformdesigner.runtime.LayoutCreator;
import java.util.HashMap;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class LayoutCreatorRegistry {
    private static HashMap<String, Object> layoutsMap;
    private static HashMap<Class<?>, Class<?>> layoutsCacheMap;

    LayoutCreatorRegistry() {
    }

    static LayoutCreator createLayoutCreator(Class<?> layoutClass) throws InstantiationException, IllegalAccessException {
        Class<?> creatorClass = LayoutCreatorRegistry.getLayoutCreatorClass(layoutClass);
        if (creatorClass == null) {
            throw new IllegalArgumentException(new StringBuffer().append("layout class \"").append(layoutClass).append("\" not supported").toString());
        }
        return (LayoutCreator)creatorClass.newInstance();
    }

    private static Class<?> getLayoutCreatorClass(Class<?> layoutClass) {
        if (layoutClass == null) {
            throw new IllegalArgumentException("layoutClass is null");
        }
        Class<?> creatorClass = layoutsCacheMap.get(layoutClass);
        if (creatorClass != null) {
            return creatorClass;
        }
        Object nameOrClass = layoutsMap.get(layoutClass.getName());
        if (nameOrClass instanceof Class) {
            creatorClass = (Class<?>)nameOrClass;
            layoutsCacheMap.put(layoutClass, creatorClass);
            return creatorClass;
        }
        String name = (String)nameOrClass;
        if (name == null) {
            Class<?> cls = layoutClass.getSuperclass();
            return cls != null ? LayoutCreatorRegistry.getLayoutCreatorClass(cls) : null;
        }
        try {
            creatorClass = Class.forName(name);
            layoutsCacheMap.put(layoutClass, creatorClass);
            return creatorClass;
        }
        catch (Exception ex) {
            return null;
        }
    }

    static {
        String groupLayoutCreatorClass;
        layoutsMap = new HashMap();
        layoutsCacheMap = new HashMap();
        try {
            Class.forName("javax.swing.GroupLayout");
            groupLayoutCreatorClass = "com.jformdesigner.runtime.GroupLayout6Creator";
            Class.forName(groupLayoutCreatorClass);
        }
        catch (ClassNotFoundException ex) {
            groupLayoutCreatorClass = "com.jformdesigner.runtime.GroupLayoutCreator";
        }
        layoutsMap.put("java.awt.BorderLayout", "com.jformdesigner.runtime.BorderLayoutCreator");
        layoutsMap.put("java.awt.CardLayout", "com.jformdesigner.runtime.CardLayoutCreator");
        layoutsMap.put("java.awt.FlowLayout", "com.jformdesigner.runtime.FlowLayoutCreator");
        layoutsMap.put("java.awt.GridLayout", "com.jformdesigner.runtime.GridLayoutCreator");
        layoutsMap.put("java.awt.GridBagLayout", "com.jformdesigner.runtime.GridBagLayoutCreator");
        layoutsMap.put("javax.swing.BoxLayout", "com.jformdesigner.runtime.BoxLayoutCreator");
        layoutsMap.put("com.jformdesigner.runtime.NullLayout", "com.jformdesigner.runtime.NullLayoutCreator");
        layoutsMap.put("org.jdesktop.layout.GroupLayout", groupLayoutCreatorClass);
        layoutsMap.put("com.jgoodies.forms.layout.FormLayout", "com.jformdesigner.runtime.FormLayoutCreator");
        layoutsMap.put("info.clearthought.layout.TableLayout", "com.jformdesigner.runtime.TableLayoutCreator");
        layoutsMap.put("com.intellij.uiDesigner.core.GridLayoutManager", "com.jformdesigner.runtime.IntelliJGridLayoutCreator");
        layoutsMap.put("org.jdesktop.swingx.HorizontalLayout", "com.jformdesigner.runtime.HorizontalLayoutCreator");
        layoutsMap.put("org.jdesktop.swingx.VerticalLayout", "com.jformdesigner.runtime.VerticalLayoutCreator");
        layoutsMap.put("javax.swing.JLayeredPane", "com.jformdesigner.runtime.JLayeredPaneCreator");
        layoutsMap.put("javax.swing.JMenu", "com.jformdesigner.runtime.JMenuCreator");
        layoutsMap.put("javax.swing.JMenuBar", "com.jformdesigner.runtime.JMenuBarCreator");
        layoutsMap.put("javax.swing.JPopupMenu", "com.jformdesigner.runtime.JPopupMenuCreator");
        layoutsMap.put("javax.swing.JScrollPane", "com.jformdesigner.runtime.JScrollPaneCreator");
        layoutsMap.put("javax.swing.JSplitPane", "com.jformdesigner.runtime.JSplitPaneCreator");
        layoutsMap.put("javax.swing.JTabbedPane", "com.jformdesigner.runtime.JTabbedPaneCreator");
        layoutsMap.put("javax.swing.JToolBar", "com.jformdesigner.runtime.JToolBarCreator");
        layoutsMap.put("javax.swing.JViewport", "com.jformdesigner.runtime.JViewportCreator");
        layoutsMap.put("com.jformdesigner.runtime.GenericIndexLayout", "com.jformdesigner.runtime.GenericIndexLayoutCreator");
        layoutsMap.put("javax.swing.ScrollPaneLayout", "com.jformdesigner.runtime.JScrollPaneCreator");
        layoutsMap.put("javax.swing.plaf.basic.BasicTabbedPaneUI$TabbedPaneLayout", "com.jformdesigner.runtime.JTabbedPaneCreator");
    }
}

