/*
 * Copyright (C) 2003-2011 Karl Tauber <karl at jformdesigner dot com>
 * All Rights Reserved
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 *  o Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 *  o Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 *  o Neither the name of JFormDesigner or Karl Tauber nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

package com.jformdesigner.runtime;

import java.awt.GridBagConstraints;

/**
 * @author Karl Tauber
 */
public class GridBagConstraintsEx
	extends GridBagConstraints
{
	public static final int DEFAULT = -1;

	// Java 6 baseline support
	// Values are equal to Java 6 GridBagConstraints values and
	// defined here for Java 1.4 and Java 5 compatibility.
	public static final int BASELINE				= 0x100;
	public static final int BASELINE_LEADING		= 0x200;
	public static final int BASELINE_TRAILING		= 0x300;
	public static final int ABOVE_BASELINE			= 0x400;
	public static final int ABOVE_BASELINE_LEADING	= 0x500;
	public static final int ABOVE_BASELINE_TRAILING	= 0x600;
	public static final int BELOW_BASELINE			= 0x700;
	public static final int BELOW_BASELINE_LEADING	= 0x800;
	public static final int BELOW_BASELINE_TRAILING	= 0x900;

	private static boolean supportsBaseline;

	private int hAlign = DEFAULT;
	private int vAlign = DEFAULT;

	static {
		try {
			GridBagConstraints.class.getField( "BASELINE" );
			supportsBaseline = true;
		} catch( Exception ex ) {
			// ignore
		}
	}

	public GridBagConstraintsEx() {
		gridx = gridy = 0;
		fill = BOTH;
	}

	public int getHAlign() {
		return hAlign;
	}

	public void setHAlign( int hAlign ) {
		this.hAlign = hAlign;
		updateAnchorFill( supportsBaseline );
	}

	public int getVAlign() {
		return vAlign;
	}

	public void setVAlign( int vAlign ) {
		this.vAlign = vAlign;
		updateAnchorFill( supportsBaseline );
	}

	public void updateAnchorFill( boolean supportsBaseline ) {
		int hAlign = (this.hAlign != DEFAULT) ? this.hAlign : GridBagSpec.FILL;
		int vAlign = (this.vAlign != DEFAULT) ? this.vAlign : GridBagSpec.FILL;

		if( !supportsBaseline &&
			(vAlign == GridBagSpec.BASELINE ||
			 vAlign == GridBagSpec.ABOVE_BASELINE ||
			 vAlign == GridBagSpec.BELOW_BASELINE) )
		  vAlign = GridBagSpec.CENTER;

		// update fill
		if( hAlign == GridBagSpec.FILL && vAlign == GridBagSpec.FILL )
			fill = BOTH;
		else if( hAlign == GridBagSpec.FILL )
			fill = HORIZONTAL;
		else if( vAlign == GridBagSpec.FILL )
			fill = VERTICAL;
		else
			fill = NONE;

		// update anchor
		if( hAlign == GridBagSpec.LEFT ) {
			if( vAlign == GridBagSpec.TOP )
				anchor = NORTHWEST;
			else if( vAlign == GridBagSpec.BOTTOM )
				anchor = SOUTHWEST;
			else if( vAlign == GridBagSpec.BASELINE )
				anchor = BASELINE_LEADING;
			else if( vAlign == GridBagSpec.ABOVE_BASELINE )
				anchor = ABOVE_BASELINE_LEADING;
			else if( vAlign == GridBagSpec.BELOW_BASELINE )
				anchor = BELOW_BASELINE_LEADING;
			else
				anchor = WEST;
		} else if( hAlign == GridBagSpec.RIGHT ) {
			if( vAlign == GridBagSpec.TOP )
				anchor = NORTHEAST;
			else if( vAlign == GridBagSpec.BOTTOM )
				anchor = SOUTHEAST;
			else if( vAlign == GridBagSpec.BASELINE )
				anchor = BASELINE_TRAILING;
			else if( vAlign == GridBagSpec.ABOVE_BASELINE )
				anchor = ABOVE_BASELINE_TRAILING;
			else if( vAlign == GridBagSpec.BELOW_BASELINE )
				anchor = BELOW_BASELINE_TRAILING;
			else
				anchor = EAST;
		} else {
			// center or fill
			if( vAlign == GridBagSpec.TOP )
				anchor = NORTH;
			else if( vAlign == GridBagSpec.BOTTOM )
				anchor = SOUTH;
			else if( vAlign == GridBagSpec.BASELINE )
				anchor = BASELINE;
			else if( vAlign == GridBagSpec.ABOVE_BASELINE )
				anchor = ABOVE_BASELINE;
			else if( vAlign == GridBagSpec.BELOW_BASELINE )
				anchor = BELOW_BASELINE;
			else
				anchor = CENTER;
		}
	}
}
