
package sunsoft.jws.visual.rt.awt;

import java.awt.*;

public class CheckboxPanel extends GBPanel {

  private CheckboxGroup group;

  public CheckboxPanel() {
    super();
    group = new CheckboxGroup();
  }

  // The add(Component) method calls this version of add, so it is easier
  // to only do this override.
  public Component add(Component comp, int pos) {
    if (comp instanceof Checkbox) {
      Checkbox box = (Checkbox)comp;
      box.setCheckboxGroup(group);

      if (box.getState()) {
	if (group.getCurrent() == null)
	  group.setCurrent(box);
	else
	  box.setState(false);
      }
    }

    return super.add(comp, pos);
  }

  public void remove(Component comp) {
    if (comp instanceof Checkbox)
      ((Checkbox)comp).setCheckboxGroup(null);
    super.remove(comp);
  }

  public void removeAll() {
    int count = countComponents();
    for (int i=0; i<count; i++) {
      Component comp = getComponent(i);
      if (comp instanceof Checkbox)
	((Checkbox)comp).setCheckboxGroup(null);
    }

    super.removeAll();
  }
}
