
package sunsoft.jws.visual.rt.awt;

import java.awt.*;

public interface GBContainer {

  //
  // Initialization
  //

  public void setGBPanel(GBPanel panel);

  //
  // Container methods
  //

  public void setLayout(LayoutManager mgr);
  public void validate();
  public void invalidate();

  public Component add(Component comp, int pos);
  public void remove(Component comp);
  public void removeAll();

  public void update(Graphics g);
  public void paint(Graphics g);
  public boolean handleEvent(Event e);
  public void reshape(int x, int y, int w, int h);

  //
  // Constraints
  //

  public void setConstraints(Component comp, GBConstraints c);
  public GBConstraints getConstraints(Component comp);

  //
  // Layout and Preview modes
  //

  public void layoutMode();
  public void previewMode();

  //
  // GBLayout attributes
  //

  public void setColumnWeights(double w[]);
  public void setRowWeights(double w[]);
  public double [] getColumnWeights();
  public double [] getRowWeights();

  public void setColumnWidths(int w[]);
  public void setRowHeights(int h[]);
  public int[] getColumnWidths();
  public int[] getRowHeights();

  public void addRow(int index);
  public void addColumn(int index);
}
