/*
 *        Copyright (C) 1996  Active Software, Inc.
 *                  All rights reserved.
 *
 * @(#) KeyField.java 1.2 - last change made 06/20/96
 */

package sunsoft.jws.visual.rt.awt;

import java.awt.*;

public class KeyField extends Canvas {

  public static final int ESC = 27;
  public static final int DELETE = 127;

  private static int ipadx = 20;
  private static int ipady = 14;

  private int key;
  private FontMetrics fontMetrics;
  private boolean hasFocus;

  public void addNotify() {
    super.addNotify();
    fontMetrics = getFontMetrics(getFont());
  }

  public void removeNotify() {
    super.removeNotify();
    fontMetrics = null;
  }

  public Dimension minimumSize() {
    Dimension d = new Dimension(0, 0);

    if (fontMetrics != null) {
      d.width = fontMetrics.stringWidth("Carriage Return") + ipadx;
      d.height = fontMetrics.getMaxAscent() + ipady;
    }

    return d;
  }

  public Dimension preferredSize() {
    return minimumSize();
  }

  public void setKey(int key) {
    this.key = key;
    repaint();
  }

  public int getKey() {
    return key;
  }

  private String getKeyString() {
    String str;

    switch (key) {
    case 0:
      str = "null";
      break;
    case '\n':
      str = "Line Feed";
      break;
    case '\t':
      str = "Tab";
      break;
    case '\f':
      str = "Form Feed";
      break;
    case '\r':
      str = "Carriage Return";
      break;
    case '\b':
      str = "Back Space";
      break;
    case ' ':
      str = "Space";
      break;

    case ESC:
      str = "Esc";
      break;
    case DELETE:
      str = "Delete";
      break;

    case Event.HOME:
      str = "Home";
      break;
    case Event.END:
      str = "End";
      break;
    case Event.PGUP:
      str = "Page Up";
      break;
    case Event.PGDN:
      str = "Page Down";
      break;
    case Event.UP:
      str = "Up";
      break;
    case Event.DOWN:
      str = "Down";
      break;
    case Event.LEFT:
      str = "Left";
      break;
    case Event.RIGHT:
      str = "Right";
      break;
    case Event.F1:
      str = "F1";
      break;
    case Event.F2:
      str = "F2";
      break;
    case Event.F3:
      str = "F3";
      break;
    case Event.F4:
      str = "F4";
      break;
    case Event.F5:
      str = "F5";
      break;
    case Event.F6:
      str = "F6";
      break;
    case Event.F7:
      str = "F7";
      break;
    case Event.F8:
      str = "F8";
      break;
    case Event.F9:
      str = "F9";
      break;
    case Event.F10:
      str = "F10";
      break;
    case Event.F11:
      str = "F11";
      break;
    case Event.F12:
      str = "F12";
      break;

    default:
      if (key >= 32)
	str = String.valueOf((char)key);
      else
	str = "^" + String.valueOf((char)(key+'A'-1));

      break;
    }

    return str;
  }

  public void paint(Graphics g) {
    Dimension size = size();

    String str = getKeyString();
    int x = (size.width - fontMetrics.stringWidth(str)) / 2;
    int y = (size.height + fontMetrics.getMaxAscent()) / 2 - 1;
    if (isEnabled())
      g.setColor(getForeground());
    else
      g.setColor(getBackground().darker());
    g.drawString(str, x, y);

    g.setColor(getBackground());
    g.draw3DRect(1, 1, size.width-3, size.height-3, false);
    g.draw3DRect(2, 2, size.width-5, size.height-5, false);

    if (hasFocus) {
      g.setColor(getForeground());
      g.drawRect(0, 0, size.width-1, size.height-1);
    }
  }

  public boolean handleEvent(Event e) {

    if (e.id == Event.GOT_FOCUS) {
      if (!hasFocus) {
	hasFocus = true;
	repaint();
      }
    }
    else if (e.id == Event.LOST_FOCUS) {
      if (hasFocus) {
	hasFocus = false;
	repaint();
      }
    }
    else {
      return super.handleEvent(e);
    }

    return false;
  }

  public boolean mouseDown(Event e, int x, int y) {
    if (!hasFocus)
      requestFocus();
    return false;
  }

  public boolean keyDown(Event e, int key) {
    setKey(key);
    return false;
  }
}
