/*
 *        Copyright (C) 1996  Active Software, Inc.
 *                  All rights reserved.
 *
 * @(#) ScrollableArea.java 1.2 - last change made 07/22/96
 */

package sunsoft.jws.visual.rt.awt;

import sunsoft.jws.visual.rt.awt.*;

import java.awt.*;

public class ScrollableArea extends VJPanel implements Scrollable {
  private Component comp;
  private int curx, cury;
  private int lineHeight = 4;

  public void layout() {
    if (comp == null)
      return;

    Dimension d = comp.preferredSize();
    Dimension size = size();
    d.width = Math.max(d.width, size.width);
    d.height = Math.max(d.height, size.height);

    comp.reshape(curx, cury, d.width, d.height);
  }

  public Component add(Component comp, int pos) {
    if (this.comp != null)
      remove(this.comp);

    this.comp = comp;
    return super.add(comp, pos);
  }

  public void remove(Component comp) {
    super.remove(comp);
    if (this.comp == comp)
      this.comp = null;
  }

  public Dimension minimumSize() {
    if (comp != null)
      return comp.preferredSize();
    else
      return new Dimension(0, 0);
  }

  public Dimension preferredSize() {
    return minimumSize();
  }

  public void scrollX(int x) {
    curx = -x;
    if (comp != null)
      comp.move(curx, cury);
  }

  public void scrollY(int y) {
    cury = -y;
    if (comp != null)
      comp.move(curx, cury);
  }

  public Dimension scrollSize() {
    return minimumSize();
  }

  public Dimension viewSize() {
    return size();
  }

  public void setLineHeight(int lineHeight) {
    this.lineHeight = lineHeight;
  }

  public int lineHeight() {
    return lineHeight;
  }
}
