/*
 *        Copyright (C) 1996  Active Software, Inc.
 *                  All rights reserved.
 *
 * @(#) TextList.java 1.10 - last change made 07/03/96
 */

package sunsoft.jws.visual.rt.awt;

import java.awt.*;
import java.util.Vector;

/**
 * An alternate to the regular AWT List widget.
 *
 * @version 	1.10, 07/03/96
 */
public class TextList extends ScrollPanel {
  private TextView view;
  private StringVector items;

  public TextList() {
    items = new StringVector();
    view = new TextView();
    view.items(items.vector);

    add(view);

//    for (int i=0; i<100; i++)
//      items.addElement("item" + i);
//    select(0);
//    updateView();
  }

  protected void updateVScrollbar() {
    super.updateVScrollbar();
    vbar.setLineIncrement(view.lineHeight());
    vbar.setPageIncrement(view.lineHeight() * view.getMinimumRows());
  }

  //
  // Methods that are forwarded to the view.
  //
  public void enable(boolean value) {
    super.enable(value);
    view.enable(value);
  }

  public StringVector items() {
    return items;
  }

  public void updateView() {
    view.updateView();
    updateWindow();
  }

  public void setMinimumRows(int num) {
    view.setMinimumRows(num);
  }

  public int getMinimumRows() {
    return view.getMinimumRows();
  }

  public void setMinimumColumns(int num) {
    view.setMinimumColumns(num);
  }

  public int getMinimumColumns() {
    return view.getMinimumColumns();
  }

  public int getRows() {
    return view.getRows();
  }

  public void select(int index) {
    view.select(index);
  }

  public void deselect(int index) {
    view.deselect(index);
  }

  public int getSelectedIndex() {
    return view.getSelectedIndex();
  }

  public String getSelectedItem() {
    return (String)view.getSelectedItem();
  }
  
  
  public void addItem(String item) {
    items.addElement(item);
    updateView();
  }

  public void addItem(String item, int index) {
    if (index == -1) {
      if (items.size() == 0) {
	items.addElement(item);
      }
      else {
	items.insertElementAt(item,0);
      }
    }
    else if (index < items.size()) {
      items.insertElementAt(item,index);
    }
    else {
      items.addElement(item);
    }
    updateView();
  }

  public void replaceItem(String newValue, int index) {
    if (index < items.size()) {
      items.setElementAt(newValue,index);
      updateView();
    }
  }

  public int countItems() {
    return items.size();
  }

  public void clear() {
    items.removeAllElements();
    updateView();
  }

  public void delItem(int position) {
    if (position < items.size()) {
      items.removeElementAt(position);
      updateView();
    }
  }

  public void delItems(int start, int end) {
    for (int index=start;index<=end;index++) {
      if (index < items.size()) {
	items.removeElementAt(start);
      }
    }
    updateView();
  }

  public String getItem(int index) {
    if (index < items.size()) {
      return (items.elementAt(index));
    }
    else return null;
  }

  public void makeVisible(int index) {
    updateView();
    super.makeVisible(index);
  }
}
