/*
 *        Copyright (C) 1996  Active Software, Inc.
 *                  All rights reserved.
 *
 * @(#) AMContainer.java 1.8 - last change made 04/25/96
 */

package sunsoft.jws.visual.rt.base;

import java.util.Enumeration;

/**
 * Interface that must be implemented by the containers in shadow trees.
 *
 * @version 	1.8, 04/25/96
 */
public interface AMContainer {
  public void add(AttributeManager child);
  public void remove(AttributeManager child);
  public void addChildBody(Shadow child);
  public void updateContainerAttribute(AttributeManager child,
				       String key, Object value);
  public void removeChildBody(Shadow child);
  public void createChildren();
  public void destroyChildren();
  public AttributeManager getChild(String name);
  public Enumeration getChildList();
  public int getChildCount();
  public void reparentChildren();
}
