/*
 *        Copyright (C) 1996  Active Software, Inc.
 *                  All rights reserved.
 *
 * @(#) Message.java 1.11 - last change made 04/29/96
 */

package sunsoft.jws.visual.rt.base;

/**
 * An event structure that can hold either an AWT event or a specialized
 * event passed between Group objects.
 *
 * @version 	1.7, 23 Apr 1996
 */
public class Message {
  public String name;
  public Object arg;
  public Object target;
  public long when;

  public String type;
  public String targetName;
  public boolean isAWT;

  public Message() {
    this(null, null, null, "", null);
  }

  public Message(Object target, String name, Object arg) {
    this(target, null, null, name, arg);
  }

  public Message(Object target, String name, Object arg, boolean isAWT) {
    this(target, null, null, name, arg);
    this.isAWT = isAWT;
  }

  public Message(Object target, String targetName, String type, String name, 
                 Object arg) { 
    this.target = target;
    this.name = name;
    this.arg = arg;
    this.when = System.currentTimeMillis();
    this.type = type;
    this.targetName = targetName;
    this.isAWT = false;
  }

  public Message(Message msg) {
    this(msg.target, msg.targetName, msg.type, msg.name, msg.arg);
    this.isAWT = msg.isAWT;
    this.when = msg.when;
  }
}
