/*
 *        Copyright (C) 1996  Active Software, Inc.
 *                  All rights reserved.
 *
 * @(#) GBPanelShadow.java 1.46 - last change made 07/19/96
 */

package sunsoft.jws.visual.rt.shadow;

import sunsoft.jws.visual.rt.shadow.java.awt.PanelShadow;
import sunsoft.jws.visual.rt.base.AttributeManager;
import sunsoft.jws.visual.rt.base.Group;
import sunsoft.jws.visual.rt.base.Shadow;
import sunsoft.jws.visual.rt.awt.GBPanel;
import sunsoft.jws.visual.rt.awt.GBLayout;
import sunsoft.jws.visual.rt.awt.GBConstraints;
import sunsoft.jws.visual.rt.type.AnchorEnum;

import java.awt.*;

/**
 * Wraps an AWT widget.  The attributes available for this
 * class are listed below.  In the type column, type names beginning
 * with "sunsoft.jws.visual.rt" have been abbreviated to begin with "rt".
 *
 * <pre>
    name            type                      default value
    -----------------------------------------------------------------------
    none
 * </pre>
 *
 * Check the super class for additional attributes.
 *
 * @see GBConstraints
 * @see VJPanelShadow
 * @see PanelShadow
 * @version 	1.46, 07/19/96
 */
public class GBPanelShadow extends VJPanelShadow {
  public GBPanelShadow() {
    attributes.add("columnWidths", "[I", null, HIDDEN);
    attributes.add("rowHeights", "[I", null, HIDDEN);
    attributes.add("columnWeights", "[D", null, HIDDEN);
    attributes.add("rowWeights", "[D", null, HIDDEN);
  }

  protected Object getOnBody(String key) {
    GBPanel panel = (GBPanel)body;

    if (key.equals("columnWidths"))
      return panel.getColumnWidths();
    else if (key.equals("rowHeights"))
      return panel.getRowHeights();
    else if (key.equals("columnWeights"))
      return panel.getColumnWeights();
    else if (key.equals("rowWeights"))
      return panel.getRowWeights();
    else
      return super.getOnBody(key);
  }

  protected void setOnBody(String key, Object value) {
    GBPanel panel = (GBPanel)body;

    if (key.equals("columnWidths"))
      panel.setColumnWidths((int[])value);
    else if (key.equals("rowHeights"))
      panel.setRowHeights((int[])value);
    else if (key.equals("columnWeights"))
      panel.setColumnWeights((double[])value);
    else if (key.equals("rowWeights"))
      panel.setRowWeights((double[])value);
    else
      super.setOnBody(key, value);
  }

  public void updateContainerAttribute(AttributeManager child,
				       String key, Object value) {
    if (key.equals("anchor")) {
      GBConstraints c = (GBConstraints)child.get("GBConstraints");
      if (c == null)
	return;

      int anchor = ((AnchorEnum)value).intValue();
      if (anchor != c.anchor) {
	c.anchor = anchor;
	child.set("GBConstraints", c);
      }
    }
    else if (key.equals("insets")) {
      GBConstraints c = (GBConstraints)child.get("GBConstraints");
      if (c == null)
	return;

      Insets insets = (Insets)value;
      if (c.insets != insets) {
	c.insets = insets;
	child.set("GBConstraints", c);
      }
    }
    else if (key.equals("GBConstraints")) {
      GBConstraints c = (GBConstraints)value;
      if (c == null)
	c = new GBConstraints();

      Shadow s = (Shadow)child;
      Component comp = (Component)s.getBody();
      if (comp == null)
	return;

      int anchor = ((AnchorEnum)child.get("anchor")).intValue();
      c.anchor = anchor;
      c.insets = (Insets)child.get("insets");

      ((GBPanel)body).setConstraints(comp, c);
    }
  }

  public void createBody() {
    body = new GBPanel();
  }

  protected void postCreate() {
    super.postCreate();
    if (isLayoutMode())
      ((GBPanel)body).layoutMode();
    else
      ((GBPanel)body).previewMode();
  }

  /**
   * Set the runtime flag in registerBody so that subclasses of
   * GBPanelShadow will work properly.
   */
  protected void registerBody() {
    ((GBPanel)body).setRuntime(!inDesignerRoot());
    super.registerBody();
  }

  public void layoutMode() {
    super.layoutMode();
    if (body != null)
      ((GBPanel)body).layoutMode();
  }

  public void previewMode() {
    super.previewMode();
    if (body != null)
      ((GBPanel)body).previewMode();
  }
}
