/*
 *        Copyright (C) 1996  Active Software, Inc.
 *                  All rights reserved.
 *
 * @(#) ImageButtonShadow.java 1.25 - last change made 07/19/96
 */

package sunsoft.jws.visual.rt.shadow;

import sunsoft.jws.visual.rt.type.ImageRef;
import sunsoft.jws.visual.rt.awt.ImageButton;

/**
 * Wraps an AWT widget.  The attributes available for this
 * class are listed below.  In the type column, type names beginning
 * with "sunsoft.jws.visual.rt" have been abbreviated to begin with "rt".
 *
 * <pre>
    name            type                      default value
    -----------------------------------------------------------------------
    lineWidth       java.lang.Integer         2 
  + padWidth        java.lang.Integer         2 
    pressMovement   java.lang.Integer         1 
 * </pre>
 *
 * + = this attribute overrides one inherited from an ancestor class.
 * <p>
 * Check the super class for additional attributes.
 *
 * @see ImageButton
 * @version 	1.25, 07/19/96
 */
public class ImageButtonShadow extends ImageLabelShadow {
  public ImageButtonShadow() {
    attributes.add("padWidth", "java.lang.Integer", new Integer(2), 0);
    attributes.add("lineWidth", "java.lang.Integer", new Integer(2), 0);
    attributes.add("pressMovement", "java.lang.Integer", new Integer(1), 0);
  }

  protected Object getOnBody(String key) {
    ImageButton button = (ImageButton)body;

    if (key.equals("lineWidth"))
      return(new Integer(button.getLineWidth()));
    else if (key.equals("pressMovement"))
      return(new Integer(button.getPressMovement()));
    else
      return(super.getOnBody(key));
  }

  protected void setOnBody(String key, Object value) {
    ImageButton button = (ImageButton)body;

    if (key.equals("lineWidth"))
      button.setLineWidth(((Integer) value).intValue());
    else if (key.equals("pressMovement"))
      button.setPressMovement(((Integer) value).intValue());
    else
      super.setOnBody(key, value);
  }

  public void createBody() {
    body = new ImageButton(null);
  }
}
