/*
 *        Copyright (C) 1996  Active Software, Inc.
 *                  All rights reserved.
 *
 * @(#) ImageLabelShadow.java 1.26 - last change made 07/19/96
 */

package sunsoft.jws.visual.rt.shadow;

import sunsoft.jws.visual.rt.base.VJException;
import sunsoft.jws.visual.rt.type.ImageRef;
import sunsoft.jws.visual.rt.shadow.java.awt.CanvasShadow;
import sunsoft.jws.visual.rt.awt.ImageLabel;

import java.applet.Applet;
import java.awt.Color;

/**
 * Wraps an AWT widget.  The attributes available for this
 * class are listed below.  In the type column, type names beginning
 * with "sunsoft.jws.visual.rt" have been abbreviated to begin with "rt".
 *
 * <pre>
    name            type                      default value
    -----------------------------------------------------------------------
    image           rt.type.ImageRef          null
    padWidth        java.lang.Integer         0 
 * </pre>
 *
 * Check the super class for additional attributes.
 *
 * @see ImageLabel
 * @version 	1.26, 07/19/96
 */
public class ImageLabelShadow extends CanvasShadow {
  public ImageLabelShadow() {
    attributes.add("image", "sunsoft.jws.visual.rt.type.ImageRef", null, 0);
    attributes.add("padWidth", "java.lang.Integer", new Integer(0), 0);

    // foreground color is meaningless to an image label or button
    // so don't let it be user editable
    attributes.add("foreground", "java.awt.Color", Color.black, HIDDEN);
  }

  protected Object getOnBody(String key) {
    if (key.equals("padWidth"))
      return(new Integer(((ImageLabel) body).getPadWidth()));
    else if (key.equals("image"))
      return(getFromTable("image"));  // no value available from body
    else
      return(super.getOnBody(key));
  }

  protected void setOnBody(String key, Object value) {
    ImageLabel label = (ImageLabel)body;

    if (key.equals("padWidth"))
      label.setPadWidth(((Integer) value).intValue());
    else if (key.equals("image")) {
      ImageRef ref = (ImageRef)value;
      if (ref == null)
	label.setImage(null);
      else {
	Applet applet = getGroup().getApplet();
	try {
	  label.setImage(ref.getImage(label, applet));
	  label.setDefaultWidth(ref.getWidth(label, applet));
	  label.setDefaultHeight(ref.getHeight(label, applet));
	}
	catch (VJException ex) {
	  if (isLive())
	    System.out.println("Error: " + ex.getMessage());
	  else
	    throw ex;
	}
      }
    }
    else
      super.setOnBody(key, value);
  }

  public void createBody() {
    body = new ImageLabel(null);
  }
}
