/*
 *        Copyright (C) 1996  Active Software, Inc.
 *                  All rights reserved.
 *
 * @(#) LabelBarShadow.java 1.24 - last change made 08/02/96
 */

package sunsoft.jws.visual.rt.shadow;

import sunsoft.jws.visual.rt.awt.GBConstraints;
import sunsoft.jws.visual.rt.awt.LabelBar;
import sunsoft.jws.visual.rt.shadow.java.awt.CanvasShadow;
import sunsoft.jws.visual.rt.type.AlignmentEnum;

/**
 * Wraps an AWT widget.  The attributes available for this
 * class are listed below.  In the type column, type names beginning
 * with "sunsoft.jws.visual.rt" have been abbreviated to begin with "rt".
 *
 * <pre>
    name            type                      default value
    -----------------------------------------------------------------------
    alignment       rt.type.AlignmentEnum     left 
    text            java.lang.String          "" 
    textOffsetFromEdge java.lang.Integer      10 
 * </pre>
 *
 * alignment: label bars can have a text label, if can be either
 * "left", "center", or "right"
 * <p>
 * textOffsetFromEdge: if alignment is "left" or "right", this
 * attribute controls how many pixels from the edge the label will be
 * <p>
 * Check the super class for additional attributes.
 *
 * @see LabelBar
 * @version 1.24, 08/02/96
 */
public class LabelBarShadow extends CanvasShadow {
  public LabelBarShadow() {
    attributes.add("text", "java.lang.String", "", NOEDITOR);
    attributes.add("alignment", "sunsoft.jws.visual.rt.type.AlignmentEnum",
		   new AlignmentEnum(LabelBar.LEFT), 0);
    attributes.add("textOffsetFromEdge", "java.lang.Integer", new Integer(10),
		   0);

    GBConstraints c = (GBConstraints)get("GBConstraints");
    c.fill = GBConstraints.HORIZONTAL;
    attributes.add("GBConstraints",
		   "sunsoft.jws.visual.rt.awt.GBConstraints", c);
  }

  protected Object getOnBody(String key) {
    if (key.equals("text"))
      return(((LabelBar) body).getLabel());
    else if (key.equals("alignment"))
      return(new AlignmentEnum(((LabelBar) body).getAlignment()));
    else if (key.equals("textOffsetFromEdge"))
      return(new Integer(((LabelBar) body).getLabelOffsetFromEdge()));
    else
      return(super.getOnBody(key));
  }

  protected void setOnBody(String key, Object value) {
    if (key.equals("text"))
      ((LabelBar) body).setLabel((String) value);
    else if (key.equals("alignment"))
      ((LabelBar) body).setAlignment(((AlignmentEnum) value).intValue());
    else if (key.equals("textOffsetFromEdge"))
      ((LabelBar) body).setLabelOffsetFromEdge(((Integer) value).intValue());
    else
      super.setOnBody(key, value);
  }

  public void createBody() {
    body = new LabelBar((String) (getFromTable("text")));
  }
}
