/*
 *        Copyright (C) 1996  Active Software, Inc.
 *                  All rights reserved.
 *
 * @(#) MultiLineLabelShadow.java 1.2 - last change made 07/19/96
 */

package sunsoft.jws.visual.rt.shadow;

import sunsoft.jws.visual.rt.shadow.java.awt.CanvasShadow;
import sunsoft.jws.visual.rt.awt.MultiLineLabel;
import sunsoft.jws.visual.rt.type.AlignmentEnum;

import java.util.*;
import java.awt.*;

/**
 * Wraps an AWT widget.  The attributes available for this
 * class are listed below.  In the type column, type names beginning
 * with "sunsoft.jws.visual.rt" have been abbreviated to begin with "rt".
 *
 * <pre>
    name            type                      default value
    -----------------------------------------------------------------------
  + text            java.lang.String          "MultiLineLabel"
    alignment       rt.type.AlignmentEnum     left
 * </pre>
 *
 * Check the super class for additional attributes.
 *
 * @see MultiLineLabel
 * @version 	1.2, 07/19/96
 */
public class MultiLineLabelShadow extends CanvasShadow {
  public MultiLineLabelShadow() {
    attributes.add("text", "java.lang.String", "MultiLineLabel", 0);
    attributes.add("alignment", "sunsoft.jws.visual.rt.type.AlignmentEnum",
		   new AlignmentEnum(Label.LEFT), 0);
  }

  protected Object getOnBody(String key) {
    MultiLineLabel label = (MultiLineLabel)body;

    if (key.equals("text")) {
      return label.getLabel();
    }
    else if (key.equals("alignment")) {
      return new AlignmentEnum(label.getAlignment());
    }
    else
      return(super.getOnBody(key));
  }

  protected void setOnBody(String key, Object value) {
    MultiLineLabel label = (MultiLineLabel)body;

    if (key.equals("text")) {
      label.setLabel((String)value);
    }
    else if (key.equals("alignment")) {
      label.setAlignment(((AlignmentEnum)value).intValue());
    }
    else {
      super.setOnBody(key, value);
    }
  }

  public void createBody() {
    body = new MultiLineLabel();
  }
}
