/*
 *        Copyright (C) 1996  Active Software, Inc.
 *                  All rights reserved.
 *
 * @(#) ScrollableAreaShadow.java 1.2 - last change made 07/19/96
 */

package sunsoft.jws.visual.rt.shadow;

import sunsoft.jws.visual.rt.awt.ScrollableArea;
import sunsoft.jws.visual.rt.shadow.java.awt.PanelShadow;

import java.util.Enumeration;

/**
 * Wraps an AWT widget.  The attributes available for this
 * class are listed below.  In the type column, type names beginning
 * with "sunsoft.jws.visual.rt" have been abbreviated to begin with "rt".
 *
 * <pre>
    name            type                      default value
    -----------------------------------------------------------------------
    lineHeight      java.lang.Integer         4
 * </pre>
 *
 * Check the super class for additional attributes.
 *
 * @see ScrollableArea
 * @see ScrollPanelShadow
 * @version 1.2, 07/19/96
 */
public class ScrollableAreaShadow extends PanelShadow {

  public ScrollableAreaShadow() {
    attributes.add("lineHeight", "java.lang.Integer", new Integer(4), 0);
  }

  protected Object getOnBody(String key) {
    if (key.equals("lineHeight"))
      return new Integer(((ScrollableArea)body).lineHeight());
    else
      return super.getOnBody(key);
  }

  protected void setOnBody(String key, Object value) {
    if (key.equals("lineHeight"))
      ((ScrollableArea)body).setLineHeight(((Integer)value).intValue());
    else
      super.setOnBody(key, value);
  }

  public void create() {
    // Add a GBPanelShadow child if there isn't one already.
    if (inDesignerRoot()) {
      boolean found = false;

      Enumeration e = getChildList();
      while (e.hasMoreElements()) {
	if (e.nextElement() instanceof GBPanelShadow)
	  found = true;
      }

      if (!found) {
	GBPanelShadow s = new GBPanelShadow();
	int w[] = {14, 14};
	s.set("columnWidths", w);
	int h[] = {14, 14};
	s.set("rowHeights", h);
	add(s);
      }
    }

    super.create();
  }

  public void createBody() {
    body = new ScrollableArea();
  }
}
