/*
 *        Copyright (C) 1996  Active Software, Inc.
 *                  All rights reserved.
 *
 * @(#) VJPanelShadow.java 1.4 - last change made 08/02/96
 */

package sunsoft.jws.visual.rt.shadow;

import sunsoft.jws.visual.rt.awt.VJPanel;
import sunsoft.jws.visual.rt.base.AttributeManager;
import sunsoft.jws.visual.rt.type.AlignmentEnum;
import sunsoft.jws.visual.rt.type.ReliefEnum;
import sunsoft.jws.visual.rt.shadow.java.awt.PanelShadow;

import java.awt.FlowLayout;

/**
 * Wraps an AWT widget.  The attributes available for this
 * class are listed below.  In the type column, type names beginning
 * with "sunsoft.jws.visual.rt" have been abbreviated to begin with "rt".
 *
 * <pre>
    name            type                       default value
    -----------------------------------------------------------------------
    borderLabel     java.lang.String           null
    borderLabelAlignment rt.type.AlignmentEnum left
    borderRelief    rt.type.ReliefEnum         flat 
    borderWidth     java.lang.Integer          2 
 * </pre>
 *
 * borderLabel: a recently added new feature: panels can have bevelled
 * borders and a labelin the top line somewhere, borderLabel is the
 * text of the label.  When null, there is no label.
 * <p>
 * borderLabelAlignment: either "left", "center", or "right", determines where
 * on the top bevel line the label goes.
 * <p>
 * borderRelief: There are a number of different border drawing styles
 * available for panels, and the user can see what they look like by
 * trying them out: "flat", "raised", "sunken", "ridge", "groove",
 * "win95 raised", "win95 sunken", "win95 field border", "win95 window
 * border"
 * <p>
 * borderWidth: the number of pixels wide the border will be drawn
 * <p>
 *
 * Check the super class for additional attributes.
 *
 * @see VJPanel
 * @version 1.4, 08/02/96
 */
public class VJPanelShadow extends PanelShadow {
  public VJPanelShadow() {
    attributes.add("borderLabel", "java.lang.String", null, NOEDITOR);
    attributes.add("borderRelief", "sunsoft.jws.visual.rt.type.ReliefEnum",
		   new ReliefEnum(), 0);
    attributes.add("borderWidth", "java.lang.Integer", new Integer(2), 0);
    attributes.add("borderLabelAlignment",
		   "sunsoft.jws.visual.rt.type.AlignmentEnum",
		   new AlignmentEnum(), 0);

    // These attributes are needed for top level panels that are loaded
    // in the designer.  A frame is placed around the panel, and the
    // frame needs to know what size to be.  The panel can ignore the
    // settings for these attributes.
    attributes.add("layoutLocation", "java.awt.Point", null, HIDDEN | NONBODY);
    attributes.add("layoutSize", "java.awt.Dimension", null, HIDDEN | NONBODY);
  }

  public void createBody() {
    VJPanel panel = new VJPanel();
    panel.setLayout(new FlowLayout());
    body = panel;
  }

  protected Object getOnBody(String key) {
    VJPanel panel = (VJPanel)body;
    
    if (key.equals("borderRelief")) {
      return new ReliefEnum(panel.getRelief());
    }
    else if (key.equals("borderWidth")) {
      return new Integer(panel.getBorderWidth());
    }
    else if (key.equals("borderLabel")) {
      return panel.getBorderLabel();
    }
    else if (key.equals("borderLabelAlignment")) {
      return new AlignmentEnum(panel.getLabelAlignment());
    }
    else {
      return super.getOnBody(key);
    }
  }

  protected void setOnBody(String key, Object value) {
    VJPanel panel = (VJPanel)body;

    if (key.equals("borderRelief")) {
      panel.setRelief(((ReliefEnum)value).intValue());
    }
    else if (key.equals("borderWidth")) {
      panel.setBorderWidth(((Integer)value).intValue());
    }
    else if (key.equals("borderLabel")) {
      panel.setBorderLabel((String)value);
    }
    else if (key.equals("borderLabelAlignment")) {
      panel.setLabelAlignment(((AlignmentEnum)value).intValue());
    }
    else {
      super.setOnBody(key, value);
    }
  }
}
