/*
 *        Copyright (C) 1996  Active Software, Inc.
 *                  All rights reserved.
 *
 * @(#) ButtonShadow.java 1.22 - last change made 08/02/96
 */

package sunsoft.jws.visual.rt.shadow.java.awt;

import sunsoft.jws.visual.rt.base.Global;
import sunsoft.jws.visual.rt.awt.*;

import java.awt.Button;
import java.awt.Insets;

/**
 * Wraps an AWT widget.  The attributes available for this
 * class are listed below.  In the type column, type names beginning
 * with "sunsoft.jws.visual.rt" have been abbreviated to begin with "rt".
 *
 * <pre>
    name            type                      default value
    -----------------------------------------------------------------------
    standard        java.lang.Boolean         true 
    text            java.lang.String          button 
 * </pre>
 *
 * Check the super class for additional attributes.
 *
 * @see Button
 * @version 	1.22, 08/02/96
 */
public class ButtonShadow extends ComponentShadow {
  public ButtonShadow() {
    attributes.add("text", "java.lang.String", "button", NOEDITOR);
    attributes.add("standard", "java.lang.Boolean", Boolean.TRUE, 0);

    if (Global.isWindows()) {
      attributes.add("insets", "java.awt.Insets", 
		     new Insets(2, 2, 2, 2), NONBODY | CONTAINER);
    }
  }

  protected Object getOnBody(String key) {
    Button button = (Button)body;

    if (key.equals("text")) {
      return button.getLabel();
    }
    else if (key.equals("standard")) {
      if (button instanceof VJButton)
	return new Boolean(((VJButton)button).isStandard());
      else
	return Boolean.FALSE;
    }
    else {
      return super.getOnBody(key);
    }
  }

  protected void setOnBody(String key, Object value) {
    Button button = (Button)body;

    if (key.equals("text")) {
      String text = button.getLabel();
      if ((value == null && text != null)
	  || (value != null && !value.equals(text)))
	button.setLabel((String) value);
    }
    else if (key.equals("standard")) {
      if (button instanceof VJButton)
	((VJButton)button).setStandard(((Boolean)value).booleanValue());
    }
    else {
      super.setOnBody(key, value);
    }
  }

  public void createBody() {
    body = new VJButton();
  }
}
