/*
 *        Copyright (C) 1996  Active Software, Inc.
 *                  All rights reserved.
 *
 * @(#) CheckboxShadow.java 1.18 - last change made 08/02/96
 */

package sunsoft.jws.visual.rt.shadow.java.awt;

import java.awt.Checkbox;

/**
 * Wraps an AWT widget.  The attributes available for this
 * class are listed below.  In the type column, type names beginning
 * with "sunsoft.jws.visual.rt" have been abbreviated to begin with "rt".
 *
 * <pre>
    name            type                      default value
    -----------------------------------------------------------------------
    state           java.lang.Boolean         false 
    text            java.lang.String          checkbox 
 * </pre>
 *
 * Check the super class for additional attributes.
 *
 * @see Checkbox
 * @version 	1.18, 08/02/96
 */
public class CheckboxShadow extends ComponentShadow {
  public CheckboxShadow() {
    // A bug in AWT keeps us from changing the label in a checkbox
    // (the setLabel() method doesn't work.)  For now the "text" attribute
    // is given the CONSTRUCTOR flag to work around this bug.
    attributes.add("text", "java.lang.String",
		   "checkbox", CONSTRUCTOR | NOEDITOR);
    attributes.add("state","java.lang.Boolean", Boolean.FALSE, 0);
  }

  protected Object getOnBody(String key) {
    if (key.equals("text"))
      return(((Checkbox) body).getLabel());
    else if (key.equals("state"))
      return(new Boolean((((Checkbox) body).getState())));
    else
      return(super.getOnBody(key));
  }

  protected void setOnBody(String key, Object value) {
    if (key.equals("text")) {
      // WORK-AROUND: this is a constructor attribute because the
      // call below doesn't actually work (it causes a Motif error)
      // ((Checkbox) body).setLabel((String) value);
    }
    else if (key.equals("state")) {
      if (((Checkbox) body).getState() != ((Boolean) value).booleanValue())
	((Checkbox) body).setState(((Boolean) value).booleanValue());
    }
    else
      super.setOnBody(key, value);
  }

  public void createBody() {
    String text = (String) get("text");
    if (text != null)
      body = new Checkbox(text);
    else
      body = new Checkbox();
  }
}
