/*
 *        Copyright (C) 1996  Active Software, Inc.
 *                  All rights reserved.
 *
 * @(#) ChoiceShadow.java 1.9 - last change made 07/19/96
 */

package sunsoft.jws.visual.rt.shadow.java.awt;

import sunsoft.jws.visual.rt.base.Global;
import java.awt.*;

/**
 * Wraps an AWT widget.  The attributes available for this
 * class are listed below.  In the type column, type names beginning
 * with "sunsoft.jws.visual.rt" have been abbreviated to begin with "rt".
 *
 * <pre>
    name            type                      default value
    -----------------------------------------------------------------------
    items           [Ljava.lang.String;       item1,item2 
    selectedItem    java.lang.String          "" 
 * </pre>
 *
 * selectedItem: is the item (amoung the the strings in the "items"
 * attribute) that is currently showing in the choice field.  This
 * attribute is not available in the attribute editor, but is instead
 * expected to be used programmatically to change the setting on the
 * choice as the result of a callback or some such.
 * <p>
 * Check the super class for additional attributes.
 *
 * @see Choice
 * @version 	1.9, 07/19/96
 */
public class ChoiceShadow extends ComponentShadow {
  public ChoiceShadow() {
    String items[] = {"item1","item2"};
    attributes.add("items", "[Ljava.lang.String;", items, CONSTRUCTOR);
    attributes.add("selectedItem", "java.lang.String", "", HIDDEN);

    // On WindowsNT, choice menus look bad because they have extra
    // space on the bottom.  Setting the insets here tries to adjust
    // for this problem.
    if (Global.isWindowsNT()) {
      attributes.add("insets", "java.awt.Insets", new Insets(2, 0, 0, 0));
    }
    else if (Global.isMotif()) {
      // Motif choice menus hang out over their bottom and right edges.
      // The problem is worse on SGI than Sun.
      if (Global.isIrix())
	attributes.add("insets", "java.awt.Insets", new Insets(0, 0, 4, 12));
      else
	attributes.add("insets", "java.awt.Insets", new Insets(0, 0, 2, 6));
    }
  }

  protected Object getOnBody(String key) {
    if (key.equals("items")) {
      Choice choice = (Choice)body;
      int count = choice.countItems();
      String value[] = new String[count];

      for (int i=0; i<count; i++)
	value[i] = choice.getItem(i);
      return value;
    }
    else if (key.equals("selectedItem")) {
      Choice choice = (Choice)body;
      return choice.getSelectedItem();
    }
    else 
      return(super.getOnBody(key));
  }

  protected void setOnBody(String key, Object value) {
    if (key.equals("items")) {
      // The "items" attribute is handled in the createBody method below
    }
    else if (key.equals("selectedItem")) {
      Choice choice = (Choice)body;
      choice.select((String)value);
    }
    else
      super.setOnBody(key, value);
  }

  public void createBody() {
    Choice choice = new Choice();

    String s[] = (String[])get("items");

    // Motif workaround: Need to add at least one item to the choice menu
    // or else Motif will cause a core dump.
    if (s == null || s.length == 0)
      choice.addItem("     ");
    else {
      for (int i=0; i<s.length; i++)
	choice.addItem(s[i]);
    }

    body = choice;
  }
}
