/*
 *        Copyright (C) 1996  Active Software, Inc.
 *                  All rights reserved.
 *
 * @(#) LabelShadow.java 1.22 - last change made 08/02/96
 */

package sunsoft.jws.visual.rt.shadow.java.awt;

import sunsoft.jws.visual.rt.type.AlignmentEnum;
import java.awt.Label;

/**
 * Wraps an AWT widget.  The attributes available for this
 * class are listed below.  In the type column, type names beginning
 * with "sunsoft.jws.visual.rt" have been abbreviated to begin with "rt".
 *
 * <pre>
    name            type                      default value
    -----------------------------------------------------------------------
    alignment       rt.type.AlignmentEnum     center 
    text            java.lang.String          label 
 * </pre>
 *
 * Check the super class for additional attributes.
 *
 * @see Label
 * @version 	1.22, 08/02/96
 */
public class LabelShadow extends ComponentShadow {
  public LabelShadow() {
    attributes.add("text", "java.lang.String", "label", NOEDITOR);
    attributes.add("alignment", "sunsoft.jws.visual.rt.type.AlignmentEnum",
		   new AlignmentEnum(Label.CENTER), 0);
  }

  protected Object getOnBody(String key) {
    if (key.equals("text"))
      return(((Label) body).getText());
    else if (key.equals("alignment"))
      return(new AlignmentEnum(((Label) body).getAlignment()));
    else
      return(super.getOnBody(key));
  }

  protected void setOnBody(String key, Object value) {
    Label label = (Label) body;
    
    if (key.equals("text")) {
      String text = label.getText();
      if ((value == null && text != null)
	  || (value != null && !value.equals(text)))
	label.setText((String) value);
    }
    else if (key.equals("alignment"))
      label.setAlignment(((AlignmentEnum) value).intValue());
    else
      super.setOnBody(key, value);
  }

  public void createBody() {
    body = new Label();
  }
}
