/*
 *        Copyright (C) 1996  Active Software, Inc.
 *                  All rights reserved.
 *
 * @(#) MenuBarShadow.java 1.35 - last change made 07/19/96
 */

package sunsoft.jws.visual.rt.shadow.java.awt;

import sunsoft.jws.visual.rt.base.*;
import sunsoft.jws.visual.rt.type.AMRef;

import java.util.Enumeration;
import java.awt.MenuBar;
import java.awt.MenuComponent;
import java.awt.Menu;

/**
 * Wraps an AWT widget.  The attributes available for this
 * class are listed below.  In the type column, type names beginning
 * with "sunsoft.jws.visual.rt" have been abbreviated to begin with "rt".
 *
 * <pre>
    name            type                      default value
    -----------------------------------------------------------------------
    helpMenu        rt.type.AMRef             null
 * </pre>
 *
 * Check the super class for additional attributes.
 *
 * @see MenuBar
 * @version 	1.35, 07/19/96
 */
public class MenuBarShadow extends MenuComponentShadow implements AMContainer {
  private AMContainerHelper helper = new AMContainerHelper(this);

  public MenuBarShadow() {
    attributes.add("helpMenu", "sunsoft.jws.visual.rt.type.AMRef",
		   null, 0);
  }

  protected Object getOnBody(String key) {
    if (key.equals("helpMenu"))
      return(getFromTable("helpMenu"));  // a menu shadow ref is returned
    else
      return(super.getOnBody(key));
  }

  protected void setOnBody(String key, Object value) {
    if (key.equals("helpMenu")) {
      // Check to make sure value is set yet
      if (value != null) {
	// a reference to the help menu shadow is what is stored as attribute
	MenuShadow ms = (MenuShadow)((AMRef)value).getRef(this);
	// Create the body if it does not yet exist
	if (ms != null && ms.getBody() == null)
	  ms.createBody();
	
	if (ms != null && ms.getBody() != null)
	  ((MenuBar) body).setHelpMenu((Menu) ms.getBody());
	else
	  System.out.println("Menu bar \"" + getName() +
			     "\": Could not resolve help menu \"" +
			     ((AMRef)value).getName() + "\"");
      }
    }
    else
      super.setOnBody(key, value);
  }

  public void createBody() {
    body = new MenuBar();
  }


  // AMContainer interfaces

  public void add(AttributeManager child) {
    helper.add(child);
  } 

  public void remove(AttributeManager child) {
    helper.remove(child);
  }

  public void addChildBody(Shadow child) {
    if (body != null) {
      ((MenuBar) body).add((Menu) child.getBody());
      updateContainerAttributes((AMContainer)this, child);
    }
  }

  public void updateContainerAttribute(AttributeManager child,
				       String key, Object value) {
    // Menus could have a layout constraint specifying their position
    // in the menubar.  This is not yet implemented.
  }

  public void removeChildBody(Shadow child) {
    if (body != null) {
      ((MenuBar) body).remove((MenuComponent) child.getBody());
    }
  }

  public void createChildren() {
    helper.createChildren();
  }

  public void reparentChildren() {
    helper.reparentChildren();
  }

  public void destroyChildren() {
    helper.destroyChildren();
  }

  public AttributeManager getChild(String name) {
    return(helper.getChild(name));
  }

  public Enumeration getChildList() {
    return(helper.getChildList());
  }

  public int getChildCount() {
    return(helper.getChildCount());
  }
}
