/*
 *        Copyright (C) 1996  Active Software, Inc.
 *                  All rights reserved.
 *
 * @(#) MenuComponentShadow.java 1.19 - last change made 07/19/96
 */

package sunsoft.jws.visual.rt.shadow.java.awt;

import sunsoft.jws.visual.rt.base.Shadow;
import java.awt.MenuComponent;
import java.awt.Font;

/**
 * Wraps an AWT widget.  The attributes available for this
 * class are listed below.  In the type column, type names beginning
 * with "sunsoft.jws.visual.rt" have been abbreviated to begin with "rt".
 *
 * <pre>
    name            type                      default value
    -----------------------------------------------------------------------
    font            java.awt.Font             null
 * </pre>
 *
 * Check the super class for additional attributes.
 *
 * @see MenuComponent
 * @version 	1.19, 07/19/96
 */
public class MenuComponentShadow extends Shadow {
  public MenuComponentShadow() {
    attributes.add("font", "java.awt.Font", null, DONTFETCH | CONSTRUCTOR);
  }

  protected Object getOnBody(String key) {
    if (key.equals("font"))
      return(((MenuComponent) body).getFont());
    else
      return(super.getOnBody(key));
  }

  protected void setOnBody(String key, Object value) {
    if (key.equals("font"))
      ((MenuComponent) body).setFont((Font) value);
    else
      super.setOnBody(key, value);
  }

  public void createBody() {};
}
