/*
 *        Copyright (C) 1996  Active Software, Inc.
 *                  All rights reserved.
 *
 * @(#) MenuShadow.java 1.34 - last change made 07/26/96
 */

package sunsoft.jws.visual.rt.shadow.java.awt;

import sunsoft.jws.visual.rt.base.*;
import java.util.Enumeration;
import java.awt.*;

/**
 * Wraps an AWT widget.  The attributes available for this
 * class are listed below.  In the type column, type names beginning
 * with "sunsoft.jws.visual.rt" have been abbreviated to begin with "rt".
 *
 * <pre>
    name            type                      default value
    -----------------------------------------------------------------------
    canTearOff      java.lang.Boolean         true 
  + text            java.lang.String          menu 
 * </pre>
 *
 * + = this attribute overrides one inherited from an ancestor class.
 * <p>
 * Check the super class for additional attributes.
 *
 * @see Menu
 * @version 	1.34, 07/26/96
 */
public class MenuShadow extends MenuItemShadow implements AMContainer {
  private AMContainerHelper helper = new AMContainerHelper(this);

  public MenuShadow() {
    attributes.add("canTearOff", "java.lang.Boolean", Boolean.TRUE,
		   CONSTRUCTOR | NONBODY);
    attributes.add("text", "java.lang.String", "menu",
		   CONSTRUCTOR | NONBODY);

    if (Global.isMotif())
      attributes.add("font", "java.awt.Font",
		     new Font("Dialog", Font.PLAIN, 12), DONTFETCH);
    else if (Global.isIrix())
      attributes.add("font", "java.awt.Font",
		     new Font("Helvetica", Font.PLAIN, 12), DONTFETCH);
  }

  public void createBody() {
    Boolean canTearOff = (Boolean) getFromTable("canTearOff");
    if (canTearOff != null)
      body = new Menu((String) getFromTable("text"),
		      canTearOff.booleanValue());
    else
      body = new Menu((String) getFromTable("text"));
  }


  // AMContainer interfaces

  public void add(AttributeManager child) {
    helper.add(child);
  } 

  public void remove(AttributeManager child) {
    helper.remove(child);
  }

  public void addChildBody(Shadow child) {
    if (body != null) {
      ((Menu) body).add((MenuItem) child.getBody());
      updateContainerAttributes((AMContainer)this, child);
    }
  }

  public void updateContainerAttribute(AttributeManager child,
				       String key, Object value) {
    if (key.equals("separator")) {
      Menu menu = (Menu)body;
      MenuItemShadow menuItemShadow = (MenuItemShadow)child;
      MenuItem menuItem = (MenuItem)menuItemShadow.getBody();

      if (menu == null || menuItem == null)
	return;

      int count = menu.countItems();
      boolean val = ((Boolean)value).booleanValue();
      if (val == menuItemShadow.hasSeparator)
	return;

      if (val) {
	if (menu.getItem(count-1) == menuItem) {
	  menuItemShadow.hasSeparator = true;
	  ((Menu)body).addSeparator();
	}
	else {
	  menuItemShadow.hasSeparator = false;
	  MenuBarShadow menubar = (MenuBarShadow)getParent();
	  if (menubar != null) {
	    menubar.destroy();
	    menubar.create();
	  }
	}
      }
      else {
	menuItemShadow.hasSeparator = false;
	MenuBarShadow menubar = (MenuBarShadow)getParent();
	if (menubar != null) {
	  menubar.destroy();
	  menubar.create();
	}
      }
    }
  }

  public void removeChildBody(Shadow child) {
    if (body != null) {
      ((Menu) body).remove((MenuComponent) child.getBody());
    }
  }

  public void createChildren() {
    helper.createChildren();
  }

  public void reparentChildren() {
    helper.reparentChildren();
  }

  public void destroyChildren() {
    helper.destroyChildren();
  }

  public AttributeManager getChild(String name) {
    return(helper.getChild(name));
  }

  public Enumeration getChildList() {
    return(helper.getChildList());
  }

  public int getChildCount() {
    return(helper.getChildCount());
  }
}
