/*
 *        Copyright (C) 1996  Active Software, Inc.
 *                  All rights reserved.
 *
 * @(#) @(#) TextAreaShadow.java 1.13 - last change made 08/02/96 
 */

package sunsoft.jws.visual.rt.shadow.java.awt;

import sunsoft.jws.visual.rt.awt.GBConstraints;
import java.awt.TextArea;

/**
 * Wraps an AWT widget.  The attributes available for this
 * class are listed below.  In the type column, type names beginning
 * with "sunsoft.jws.visual.rt" have been abbreviated to begin with "rt".
 *
 * <pre>
    name            type                      default value
    -----------------------------------------------------------------------
    numColumns      java.lang.Integer         10 
    numRows         java.lang.Integer         10 
 * </pre>
 *
 * Check the super class for additional attributes.
 *
 * @see TextArea
 * @version 	1.13, 08/02/96
 */
public class TextAreaShadow extends TextComponentShadow {
  public TextAreaShadow() {
    attributes.add("numColumns", "java.lang.Integer", new Integer(10),
		   CONSTRUCTOR);
    attributes.add("numRows", "java.lang.Integer", new Integer(10),
		   CONSTRUCTOR);

    GBConstraints c = (GBConstraints)get("GBConstraints");
    c.fill = GBConstraints.BOTH;
    attributes.add("GBConstraints",
		   "sunsoft.jws.visual.rt.awt.GBConstraints", c);
  }

  protected Object getOnBody(String key) {
    TextArea textarea = (TextArea)body;

    if (key.equals("text")) {
      return textarea.getText();
    }
    else if (key.equals("numColumns")) {
      return new Integer(textarea.getColumns());
    }
    else if (key.equals("numRows")) {
      return new Integer(textarea.getRows());
    }
    else {
      return super.getOnBody(key);
    }
  }

  protected void setOnBody(String key, Object value) {
    TextArea textarea = (TextArea)body;

    if (key.equals("text")) {
      String text = (String)value;
      String text2 = textarea.getText();
      if (text == null || !text.equals(text2))
	textarea.setText(text);
    }
    else if (key.equals("numColumns")) {
      return;	// can't set this attribute dynamically
    }
    else if (key.equals("numRows")) {
      return;	// can't set this attribute dynamically
    }
    else {
      super.setOnBody(key, value);
    }
  }

  public void createBody() {
    boolean initText, initColumns, initRows;
    String initTextValue;
    Integer initColumnsValue, initRowsValue;

    initTextValue = (String)getFromTable("text");
    initText = (initTextValue != null);

    initColumnsValue = (Integer) (getFromTable("numColumns"));
    initColumns = (initColumnsValue != null);

    initRowsValue = (Integer) (getFromTable("numRows"));
    initRows = (initRowsValue != null);

    if (initText & initColumns & initRows) {
      body = new TextArea (initTextValue, initRowsValue.intValue(),
			   initColumnsValue.intValue());
    }
    else if (initColumns & initRows) {
      body = new TextArea (initRowsValue.intValue(),
			   initColumnsValue.intValue());
    }
    else if (initText) {
      body = new TextArea (initTextValue);
    }
    else {
      body = new TextArea();
    }
  }
}
