/*
 *        Copyright (C) 1996  Active Software, Inc.
 *                  All rights reserved.
 *
 * @(#) @(#) TextComponentShadow.java 1.16 - last change made 07/19/96 
 */

package sunsoft.jws.visual.rt.shadow.java.awt;

import java.awt.TextComponent;

/**
 * Wraps an AWT widget.  The attributes available for this
 * class are listed below.  In the type column, type names beginning
 * with "sunsoft.jws.visual.rt" have been abbreviated to begin with "rt".
 *
 * <pre>
    name            type                      default value
    -----------------------------------------------------------------------
    editable        java.lang.Boolean         true 
    text            java.lang.String          "" 
 * </pre>
 *
 * Check the super class for additional attributes.
 *
 * @see TextComponent
 * @version 	1.16, 07/19/96
 */
public class TextComponentShadow extends ComponentShadow {
  public TextComponentShadow() {
    attributes.add("text", "java.lang.String", "", 0);
    attributes.add("editable", "java.lang.Boolean", Boolean.TRUE, 0);
  }

  protected Object getOnBody(String key) {
    if (key.equals("text"))
      return((((TextComponent) body).getText()));
    else if (key.equals("editable"))
      return(new Boolean(((TextComponent) body).isEditable()));
    else
      return(super.getOnBody(key));
  }

  protected void setOnBody(String key, Object value) {
    TextComponent textcomp = (TextComponent)body;

    if (key.equals("text")) {
      String text = textcomp.getText();

      if ((value == null && text != null)
	  || (value != null && !value.equals(text))) {
	textcomp.setText((String) value);
      }
    }
    else if (key.equals("editable")) {
      textcomp.setEditable (((Boolean) value).booleanValue());
    }
    else {
      super.setOnBody(key, value);
    }
  }

  public void createBody() {};
}
