/*
 *        Copyright (C) 1996  Active Software, Inc.
 *                  All rights reserved.
 *
 * @(#) AMRefConverter.java 1.11 - last change made 07/18/96
 */

package sunsoft.jws.visual.rt.type;

/**
 * Converts references to attribute manager objects into their
 * names and back again.
 *
 * @see AMRef
 * @version 1.11, 07/18/96
 */
public class AMRefConverter extends Converter {
  /**
   * Converts an AMRef object to a string.
   */
  public String convertToString(Object obj) {
    if (obj != null)
      return(((AMRef) obj).getName());
    else
      return("");
  }

  /**
   * Converts a string into an AMRef object.
   *
   * @param s string to convert
   */
  public Object convertFromString(String s) {
    if (s != null && s.length() != 0)
      return(new AMRef(s));
    else
      return(null);
  }

  /**
   * Returns code for creating an AMRef object.
   *
   * @param obj AMRef object for which to generate code
   */
  public String convertToCode(Object obj) {
    return("new AMRef(\"" + convertToString(obj) + "\")");
  }  
}
