/*
 *        Copyright (C) 1996  Active Software, Inc.
 *                  All rights reserved.
 *
 * @(#) BooleanConverter.java 1.6 - last change made 07/18/96
 */

package sunsoft.jws.visual.rt.type;

/**
 * Converts Booleans to strings and back again.
 *
 * @see Boolean
 * @version 	1.6, 07/18/96
 */
public class BooleanConverter extends Converter {
  /**
   * Converts a Boolean to a string.
   *
   * @param obj an instance of Boolean
   * @return its string equivalent, "true" or "false"
   */
  public String convertToString(Object obj) {
    return(((Boolean) obj).booleanValue() ? "true" : "false");
  }

  /**
   * Converts a string to a new instance of Boolean.
   *
   * @exception ParseException when a lower-cased version of the string is not "true" or "false"
   */
  public Object convertFromString(String s) {
    if (s.toLowerCase().equals("true")) {
      return(Boolean.TRUE);
    }
    else if (s.toLowerCase().equals("false")) {
      return(Boolean.FALSE);
    }
    else {
      throw new ParseException("Illegal boolean value: " + s);
    }
  }

  /**
   * Returns a block of code representing a Boolean like the one given.
   *
   * @param obj an instance of Boolean
   */
  public String convertToCode(Object obj) {
    if (((Boolean) obj).booleanValue())
      return("Boolean.TRUE");
    else
      return("Boolean.FALSE");
  }
}
