/*
 *        Copyright (C) 1996  Active Software, Inc.
 *                  All rights reserved.
 *
 * @(#) IntArrayConverter.java 1.11 - last change made 07/30/96
 */

package sunsoft.jws.visual.rt.type;

import sunsoft.jws.visual.rt.base.Attribute;
import sunsoft.jws.visual.rt.base.Global;

import java.util.Vector;
import java.util.StringTokenizer;

/**
 * Converts array of int to a string and back again.
 * The string representation is a single line of comma-separated numbers.
 *
 * @version 	1.11, 07/30/96
 */
public class IntArrayConverter extends Converter {
  /**
   * Converts and array of int to a string representation.
   */
  public String convertToString(Object obj) {
    if (obj != null) {
      int[] a = (int[]) obj;

      StringBuffer retval = new StringBuffer();
      for (int i = 0; i < a.length; i++) {
	retval.append(a[i]);
	if (i != (a.length-1))
	  retval.append(",");
      }

      return(retval.toString());
    }
    else {
      return("");
    }
  }

  /**
   * Converts a string to an array of int.
   *
   * @exception ParseException when one of the numbers is badly formatted
   */
  public Object convertFromString(String s) {
    if (s != null) {
      Vector intbuf = new Vector();

      StringTokenizer st = new StringTokenizer(s, ",");
      for ( ; st.hasMoreTokens(); ) {
	try {
	  s = st.nextToken().trim();
	  intbuf.addElement(Integer.valueOf(s));
	} catch (NumberFormatException e) {
	  throw new ParseException("Badly formatted integer: " + s);
	}
      }

      if (intbuf.size() > 0) {
	int retval[] = new int[intbuf.size()];
	for (int i = 0; i < intbuf.size(); i++)
	  retval[i] = ((Integer) intbuf.elementAt(i)).intValue();
	return(retval);
      }
    }
    return(null);
  }

  /**
   * Converts an array of int (stored in an attribute) into a block
   * of code that will create the array without using this converter at
   * runtime.
   */
  public void convertToCodeBlock(String amName, Attribute a,
				 int indent, StringBuffer buf) {
    indent(buf, indent);
    buf.append("{");
    Global.newline(buf);

    indent += 2;
    indent(buf, indent);
    buf.append("int _tmp[] = {");
    convertToString(a.getValue(), buf);
    buf.append("};");
    Global.newline(buf);

    super.convertToCodeBlock(amName, a, indent, buf);

    indent -= 2;
    indent(buf, indent);
    buf.append("}");
    Global.newline(buf);
  }

  /**
   * Use convertToCodeBlock instead.
   */
  public String convertToCode(Object obj) {
    return("_tmp");
  }
}
