/*
 *        Copyright (C) 1996  Active Software, Inc.
 *                  All rights reserved.
 *
 * @(#) ModeEnum.java 1.2 - last change made 07/18/96
 */

package sunsoft.jws.visual.rt.type;

import java.awt.FileDialog;

/**
 * A class that knows the different file dialog modes.
 *
 * @see FileDialog
 * @version 	1.2, 07/18/96
 */
public class ModeEnum extends BaseEnum {
  private static BaseEnumHelper helper = new BaseEnumHelper();

  static {
    helper.add(FileDialog.LOAD, "load");
    helper.add(FileDialog.SAVE, "save");
    helper.setDefaultChoice(FileDialog.LOAD);
  }

  /**
   * Creates an instance with the choice set to FileDialog.LOAD.
   */
  public ModeEnum() {
    super();
  }

  /**
   * Creates an instance with the choice set to the given int value.
   *
   * @param choice FileDialog.LOAD or FileDialog.SAVE
   */
  public ModeEnum(int choice) {
    super(choice);
  }

  /**
   * Creates an instance with the choice set to the given string.
   *
   * @param choice "load" or "save"
   */
  public ModeEnum(String choice) {
    super(choice);
  }

  protected BaseEnumHelper getHelper() {
    return(helper);
  }
}
