/*
 *        Copyright (C) 1996  Active Software, Inc.
 *                  All rights reserved.
 *
 * @(#) OpArrayConverter.java 1.3 - last change made 07/18/96
 */

package sunsoft.jws.visual.rt.type;

import java.util.Enumeration;

/**
 * Converts an array of Op to a string and back again.
 *
 * @see Op
 * @version 	1.3, 07/18/96
 */
public class OpArrayConverter extends Converter {

  public void convertToString(Object obj, StringBuffer buf) {
    if (obj == null) {
      buf.append("null");
      return;
    }

    Op op[] = (Op[])obj;

    buf.append("{");
    newline(buf);
    incrIndent();

    for (int i=0; i < op.length; i++) {
      indent(buf);
      if (op[i] != null)
	op[i].convertToString(op[i], buf);
      newline(buf);
    }

    decrIndent();
    indent(buf);
    buf.append("}");
  }

  public Object convertFromString(String s) {
    if (s == null)
      return null;

    ListParser parser = new ListParser(s);
    Enumeration e = parser.elements();
    Op ops[] = new Op[parser.size()];
    int i = 0;

    while (e.hasMoreElements()) {
      ops[i] = new Op();
      ops[i].convertFromString((String)e.nextElement(), ops[i]);
      i++;
    }

    return ops;
  }

  /**
   * Returns true if this type should be displayed in an editor.
   *
   * For the attribute editor, a return value of false means that the
   * the textfield will be hidden.
   *
   * @return false
   */
  public boolean viewableAsString() {
    return(false);
  }
}
