/*
 *        Copyright (C) 1996  Active Software, Inc.
 *                  All rights reserved.
 *
 * @(#) OrientationEnum.java 1.5 - last change made 07/18/96
 */

package sunsoft.jws.visual.rt.type;

import java.awt.Scrollbar;

/**
 * A class that knows the orientation attributes of scrollbars, and in an
 * instantiation, can store the orientation attribute of a single scrollbar.
 *
 * @see Scrollbar
 * @version 	1.5, 07/18/96
 */
public class OrientationEnum extends BaseEnum {
  private static BaseEnumHelper helper = new BaseEnumHelper();

  static {
    helper = new BaseEnumHelper();
    helper.add(Scrollbar.HORIZONTAL, "horizontal");
    helper.add(Scrollbar.VERTICAL, "vertical");
    helper.setDefaultChoice(Scrollbar.VERTICAL);
  }

  /**
   * Creates an instance with the choice set to Scrollbar.VERTICAL.
   */
  public OrientationEnum() {
    super();
  }

  /**
   * Creates an instance with the choice set to the given int value.
   *
   * @param choice Scrollbar.VERTICAL or Scrollbar.HORIZONTAL
   */
  public OrientationEnum(int choice) {
    super(choice);
  }

  /**
   * Creates an instance with the choice set to the given string.
   *
   * @param choice "vertical" or "horizontal"
   */
  public OrientationEnum(String choice) {
    super(choice);
  }

  protected BaseEnumHelper getHelper() {
    return(helper);
  }
}
