/*
 *        Copyright (C) 1996  Active Software, Inc.
 *                  All rights reserved.
 *
 * @(#) ReliefEnum.java 1.2 - last change made 07/18/96
 */

package sunsoft.jws.visual.rt.type;

import sunsoft.jws.visual.rt.base.Util;

/**
 * A class that knows the different kinds of reliefs available for panels.
 *
 * @see Util
 * @see sunsoft.jws.visual.rt.awt.VJPanel
 * @version 	1.2, 07/18/96
 */
public class ReliefEnum extends BaseEnum {
  private static BaseEnumHelper helper = new BaseEnumHelper();

  static {
    helper = new BaseEnumHelper();

    helper.add(Util.RELIEF_FLAT, "flat");
    helper.add(Util.RELIEF_RAISED, "raised");
    helper.add(Util.RELIEF_SUNKEN, "sunken");
    helper.add(Util.RELIEF_RIDGE, "ridge");
    helper.add(Util.RELIEF_GROOVE, "groove");
    helper.add(Util.WIN95_RAISED, "win95 raised");
    helper.add(Util.WIN95_SUNKEN, "win95 sunken");
    helper.add(Util.WIN95_FIELD_BORDER, "win95 field border");
    helper.add(Util.WIN95_WINDOW_BORDER, "win95 window border");

    helper.setDefaultChoice(Util.RELIEF_FLAT);
  }

  /**
   * Creates an instance with the choice set to Util.RELIEF_FLAT.
   */
  public ReliefEnum() {
    super();
  }

  /**
   * Creates an instance with the choice set to the given int value.
   *
   * @param choice Util.RELIEF_FLAT, Util.RELIEF_RAISED, Util.RELIEF_SUNKEN, Util.RELIEF_RIDGE, Util.RELIEF_GROOVE, Util.WIN95_RAISED, Util.WIN95_SUNKEN, Util.WIN95_FIELD_BORDER, or Util.WIN95_WINDOW_BORDER
   */
  public ReliefEnum(int choice) {
    super(choice);
  }

  /**
   * Creates an instance with the choice set to the given string.
   *
   * @param choice "flat", "raised", "sunken", "ridge", "groove", "win95 raised", "win95 sunken", "win95 field border", or "win95 window border"
   */
  public ReliefEnum(String choice) {
    super(choice);
  }

  protected BaseEnumHelper getHelper() {
    return(helper);
  }
}
